/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorContext;
import org.apache.parquet.Strings;

public interface Compactor {
    public static final String FINAL_LOCATION = "hive.compactor.input.dir";

    public static long getCompactorTxnId(Configuration jobConf) {
        String snapshot = jobConf.get("hive.txn.valid.txns");
        if (Strings.isNullOrEmpty((String)snapshot)) {
            throw new IllegalStateException("hive.txn.valid.txns not found for writing to " + jobConf.get(FINAL_LOCATION));
        }
        ValidReadTxnList validTxnList = new ValidReadTxnList();
        validTxnList.readFromString(snapshot);
        return validTxnList.getHighWatermark();
    }

    public boolean run(CompactorContext var1) throws IOException, HiveException, InterruptedException;
}

