/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.command;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.security.authorization.command.CommandAuthorizerV1;
import org.apache.hadoop.hive.ql.security.authorization.command.CommandAuthorizerV2;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class CommandAuthorizer {
    private CommandAuthorizer() {
        throw new UnsupportedOperationException("CommandAuthorizer should not be instantiated");
    }

    public static void doAuthorization(HiveOperation op, BaseSemanticAnalyzer sem, String command) throws HiveException, AuthorizationException {
        if (CommandAuthorizer.skip(op, sem)) {
            return;
        }
        SessionState ss = SessionState.get();
        Set<ReadEntity> inputs = CommandAuthorizer.getInputs(sem);
        Set<WriteEntity> outputs = CommandAuthorizer.getOutputs(sem);
        if (!ss.isAuthorizationModeV2()) {
            CommandAuthorizerV1.doAuthorization(op, sem, ss, inputs, outputs);
        } else {
            CommandAuthorizerV2.doAuthorization(op, sem, ss, inputs, outputs, command);
        }
    }

    private static boolean skip(HiveOperation op, BaseSemanticAnalyzer sem) throws HiveException {
        if (op == HiveOperation.CREATEDATABASE) {
            for (WriteEntity e : sem.getOutputs()) {
                if (e.getType() != Entity.Type.DATABASE || !sem.getDb().databaseExists(e.getName().split(":")[1])) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<ReadEntity> getInputs(BaseSemanticAnalyzer sem) {
        HashSet<ReadEntity> additionalInputs = new HashSet<ReadEntity>();
        for (Entity entity : sem.getInputs()) {
            if (entity.getType() != Entity.Type.PARTITION) continue;
            additionalInputs.add(new ReadEntity(entity.getTable()));
        }
        return Sets.union(sem.getInputs(), additionalInputs);
    }

    private static Set<WriteEntity> getOutputs(BaseSemanticAnalyzer sem) {
        HashSet<WriteEntity> additionalOutputs = new HashSet<WriteEntity>();
        for (WriteEntity e : sem.getOutputs()) {
            if (e.getType() != Entity.Type.PARTITION) continue;
            additionalOutputs.add(new WriteEntity(e.getTable(), e.getWriteType()));
        }
        return Sets.union(sem.getOutputs(), additionalOutputs);
    }
}

