/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.google.common.collect.ImmutableMap;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.EndianUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeradataBinaryRecordReader
implements RecordReader<NullWritable, BytesWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(TeradataBinaryRecordReader.class);
    private CompressionCodecFactory compressionCodecs = null;
    private InputStream in;
    private long start;
    private long pos;
    private long end;
    private final Seekable filePosition;
    private CompressionCodec codec;
    static final String TD_ROW_LENGTH = "teradata.row.length";
    static final Map<String, Integer> TD_ROW_LENGTH_TO_BYTE_NUM = ImmutableMap.of((Object)"64kb", (Object)2, (Object)"1mb", (Object)4);
    static final String DEFAULT_TD_ROW_LENGTH = "64kb";
    static final String TD_ROW_LENGTH_1MB = "1mb";
    private byte[] recordLengthBytes;
    private byte[] valueByteArray = new byte[65536];
    private byte[] endOfRecord = new byte[1];
    private int recordLength = 0;

    public TeradataBinaryRecordReader(JobConf job, FileSplit fileSplit) throws IOException {
        LOG.debug("initialize the TeradataBinaryRecordReader");
        String rowLength = job.get(TD_ROW_LENGTH);
        if (rowLength == null) {
            LOG.debug("No table property in JobConf. Try to recover the table directly");
            Map<String, PartitionDesc> partitionDescMap = Utilities.getMapRedWork((Configuration)job).getMapWork().getAliasToPartnInfo();
            for (String alias : Utilities.getMapRedWork((Configuration)job).getMapWork().getAliasToPartnInfo().keySet()) {
                LOG.debug(String.format("the current alias: %s", alias));
                rowLength = partitionDescMap.get(alias).getTableDesc().getProperties().getProperty(TD_ROW_LENGTH);
                if (rowLength == null) continue;
                break;
            }
        }
        if (!TD_ROW_LENGTH_TO_BYTE_NUM.containsKey(rowLength = rowLength == null ? DEFAULT_TD_ROW_LENGTH : rowLength.toLowerCase())) {
            throw new IllegalArgumentException(String.format("%s doesn't support the value %s, the supported values are %s", TD_ROW_LENGTH, rowLength, TD_ROW_LENGTH_TO_BYTE_NUM.keySet()));
        }
        this.recordLengthBytes = new byte[TD_ROW_LENGTH_TO_BYTE_NUM.get(rowLength).intValue()];
        this.start = fileSplit.getStart();
        this.end = this.start + fileSplit.getLength();
        LOG.debug(String.format("The start of the file split is: %s", this.start));
        LOG.debug(String.format("The end of the file split is: %s", this.end));
        Path file = fileSplit.getPath();
        this.compressionCodecs = new CompressionCodecFactory((Configuration)job);
        this.codec = this.compressionCodecs.getCodec(file);
        FileSystem fs = file.getFileSystem((Configuration)job);
        FSDataInputStream fileIn = fs.open(fileSplit.getPath());
        this.filePosition = fileIn;
        if (this.isCompressedInput()) {
            LOG.info(String.format("Input file is compressed. Using compression code %s", this.codec.getClass().getName()));
            this.in = this.codec.createInputStream((InputStream)fileIn);
        } else {
            LOG.info("The input file is not compressed");
            this.in = fileIn;
        }
        this.pos = this.start;
    }

    public synchronized boolean next(NullWritable key, BytesWritable value) throws IOException {
        int lengthExpected = this.recordLengthBytes.length;
        int hasConsumed = this.readExpectedBytes(this.recordLengthBytes, lengthExpected);
        if (hasConsumed == 0) {
            LOG.info("Reach the End of File. No more record");
            return false;
        }
        if (hasConsumed < lengthExpected) {
            LOG.error(String.format("We expect %s bytes for the record length but read %d byte and reach the End of File.", lengthExpected, hasConsumed));
            LOG.error(String.format("The current position in the file : %s", this.getFilePosition()));
            LOG.error(String.format("The current consumed bytes: %s", this.pos));
            LOG.error(String.format("The bytes for the current record is: %s", Hex.encodeHexString((byte[])this.recordLengthBytes)));
            throw new EOFException("When reading the record length, reach the unexpected end of file.");
        }
        this.recordLength = EndianUtils.readSwappedUnsignedShort((byte[])this.recordLengthBytes, (int)0);
        this.pos += (long)lengthExpected;
        lengthExpected = this.recordLength;
        hasConsumed = this.readExpectedBytes(this.valueByteArray, lengthExpected);
        if (hasConsumed < lengthExpected) {
            LOG.error(String.format("We expect %s bytes for the record content but read %d byte and reach the End of File.", lengthExpected, hasConsumed));
            LOG.error(String.format("The current position in the file : %s", this.getFilePosition()));
            LOG.error(String.format("The current consumed bytes: %s", this.pos));
            LOG.error(String.format("The bytes for the current record is: %s", Hex.encodeHexString((byte[])this.recordLengthBytes) + Hex.encodeHexString((byte[])this.valueByteArray)));
            throw new EOFException("When reading the contend of the record, reach the unexpected end of file.");
        }
        value.set(this.valueByteArray, 0, this.recordLength);
        this.pos += (long)lengthExpected;
        lengthExpected = this.endOfRecord.length;
        hasConsumed = this.readExpectedBytes(this.endOfRecord, lengthExpected);
        if (hasConsumed < lengthExpected) {
            LOG.error(String.format("We expect %s bytes for the record end symbol but read %d byte and reach the End of File.", lengthExpected, hasConsumed));
            LOG.error(String.format("The current position in the file : %s", this.getFilePosition()));
            LOG.error(String.format("The current consumed bytes: %s", this.pos));
            LOG.error(String.format("The bytes for the current record is: %s", Hex.encodeHexString((byte[])this.recordLengthBytes) + Hex.encodeHexString((byte[])this.valueByteArray) + Hex.encodeHexString((byte[])this.endOfRecord)));
            throw new EOFException("When reading the end of record, reach the unexpected end of file.");
        }
        if (this.endOfRecord[0] != 10) {
            throw new IOException(String.format("We expect 0x0a as the record end but get %s.", Hex.encodeHexString((byte[])this.endOfRecord)));
        }
        this.pos += (long)lengthExpected;
        return true;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public BytesWritable createValue() {
        return new BytesWritable();
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public float getProgress() throws IOException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getFilePosition() - this.start) / (float)(this.end - this.start));
    }

    private boolean isCompressedInput() {
        return this.codec != null;
    }

    private synchronized long getFilePosition() throws IOException {
        long retVal = this.isCompressedInput() && this.filePosition != null ? this.filePosition.getPos() : this.getPos();
        return retVal;
    }

    private synchronized int readExpectedBytes(byte[] toWrite, int lengthExpected) throws IOException {
        int numOfByteRead;
        int curPos = 0;
        do {
            if ((numOfByteRead = this.in.read(toWrite, curPos, lengthExpected - curPos)) >= 0) continue;
            return curPos;
        } while ((curPos += numOfByteRead) < lengthExpected);
        return curPos;
    }
}

