/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.hooks.HiveHooks;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.Redactor;

public class HookUtils {
    public static String redactLogString(HiveConf conf, String logString) {
        String redactedString = logString;
        if (conf != null && logString != null) {
            List<Redactor> queryRedactors = HookUtils.readHooksFromConf(conf, HookContext.HookType.QUERY_REDACTOR_HOOKS);
            for (Redactor redactor : queryRedactors) {
                redactor.setConf((Configuration)conf);
                redactedString = redactor.redactQuery(redactedString);
            }
        }
        return redactedString;
    }

    public static <T> List<T> readHooksFromConf(HiveConf conf, HookContext.HookType type) {
        return new HiveHooks(conf).getHooks(type);
    }
}

