/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.atlas;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;

public class AtlasReplInfo {
    private final String srcDB;
    private final String tgtDB;
    private final String srcCluster;
    private final String tgtCluster;
    private final Path stagingDir;
    private final HiveConf conf;
    private final String atlasEndpoint;
    private String srcFsUri;
    private String tgtFsUri;
    private long timeStamp;
    private Path tableListFile;

    public AtlasReplInfo(String atlasEndpoint, String srcDB, String tgtDB, String srcCluster, String tgtCluster, Path stagingDir, HiveConf conf) {
        this(atlasEndpoint, srcDB, tgtDB, srcCluster, tgtCluster, stagingDir, null, conf);
    }

    public AtlasReplInfo(String atlasEndpoint, String srcDB, String tgtDB, String srcCluster, String tgtCluster, Path stagingDir, Path tableListFile, HiveConf conf) {
        this.atlasEndpoint = atlasEndpoint;
        this.srcDB = srcDB;
        this.tgtDB = tgtDB;
        this.srcCluster = srcCluster;
        this.tgtCluster = tgtCluster;
        this.stagingDir = stagingDir;
        this.conf = conf;
        this.tableListFile = tableListFile;
    }

    public String getSrcDB() {
        return this.srcDB;
    }

    public String getTgtDB() {
        return this.tgtDB;
    }

    public String getSrcCluster() {
        return this.srcCluster;
    }

    public String getTgtCluster() {
        return this.tgtCluster;
    }

    public Path getStagingDir() {
        return this.stagingDir;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public String getAtlasEndpoint() {
        return this.atlasEndpoint;
    }

    public String getSrcFsUri() {
        return this.srcFsUri;
    }

    public void setSrcFsUri(String srcFsUri) {
        this.srcFsUri = srcFsUri;
    }

    public String getTgtFsUri() {
        return this.tgtFsUri;
    }

    public void setTgtFsUri(String tgtFsUri) {
        this.tgtFsUri = tgtFsUri;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Path getTableListFile() {
        return this.tableListFile;
    }

    public void setTableListFile(Path tableListFile) {
        this.tableListFile = tableListFile;
    }

    public boolean isTableLevelRepl() {
        return this.tableListFile != null;
    }
}

