/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.api;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcNotImplementedException;
import org.apache.plc4x.java.api.messages.PlcDiscoveryRequest;
import org.apache.plc4x.java.api.metadata.OptionMetadata;
import org.apache.plc4x.java.api.metadata.PlcDriverMetadata;
import org.apache.plc4x.java.api.model.PlcTag;

public interface PlcDriver {
    public String getProtocolCode();

    public String getProtocolName();

    default public PlcDriverMetadata getMetadata() {
        return new PlcDriverMetadata(){

            @Override
            public Optional<String> getDefaultTransportCode() {
                return Optional.empty();
            }

            @Override
            public List<String> getSupportedTransportCodes() {
                return Collections.emptyList();
            }

            @Override
            public Optional<OptionMetadata> getProtocolConfigurationOptionMetadata() {
                return Optional.empty();
            }

            @Override
            public Optional<OptionMetadata> getTransportConfigurationOptionMetadata(String transportCode) {
                return Optional.empty();
            }

            @Override
            public boolean isDiscoverySupported() {
                return false;
            }
        };
    }

    public PlcConnection getConnection(String var1) throws PlcConnectionException;

    public PlcConnection getConnection(String var1, PlcAuthentication var2) throws PlcConnectionException;

    default public PlcTag prepareTag(String tagAddress) {
        throw new PlcNotImplementedException("Not implemented for " + this.getProtocolName());
    }

    default public PlcDiscoveryRequest.Builder discoveryRequestBuilder() {
        throw new PlcNotImplementedException("Not implemented for " + this.getProtocolName());
    }
}

