/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.integrity;

import java.nio.ByteBuffer;

public class IntegrityUtils {
    public static byte calculateChecksum(ByteBuffer buffer, int start) {
        int checksum = 0;
        for (int i = start; i < buffer.position(); ++i) {
            checksum += buffer.get(i);
        }
        return (byte)(-checksum);
    }

    public static void validChecksum(ByteBuffer buffer, int start) {
        byte actualChecksum;
        byte exceptChecksum = IntegrityUtils.calculateChecksum(buffer, start);
        if (exceptChecksum != (actualChecksum = buffer.get())) {
            throw new IllegalArgumentException("Checksum error, except: " + exceptChecksum + ", actual: " + actualChecksum);
        }
    }
}

