/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.env;

import com.alibaba.nacos.client.env.AbstractPropertySource;
import com.alibaba.nacos.client.env.DefaultSettingPropertySource;
import com.alibaba.nacos.client.env.JvmArgsPropertySource;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.env.PropertiesPropertySource;
import com.alibaba.nacos.client.env.SourceType;
import com.alibaba.nacos.client.env.SystemEnvPropertySource;
import com.alibaba.nacos.client.env.convert.CompositeConverter;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchableProperties
implements NacosClientProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchableProperties.class);
    private static final JvmArgsPropertySource JVM_ARGS_PROPERTY_SOURCE = new JvmArgsPropertySource();
    private static final SystemEnvPropertySource SYSTEM_ENV_PROPERTY_SOURCE = new SystemEnvPropertySource();
    private static final DefaultSettingPropertySource DEFAULT_SETTING_PROPERTY_SOURCE = new DefaultSettingPropertySource();
    private static final List<SourceType> SEARCH_ORDER;
    private static final CompositeConverter CONVERTER;
    static final SearchableProperties INSTANCE;
    private final List<AbstractPropertySource> propertySources;
    private final PropertiesPropertySource propertiesPropertySource;

    private SearchableProperties() {
        this(new PropertiesPropertySource());
    }

    private SearchableProperties(PropertiesPropertySource propertiesPropertySource) {
        this.propertiesPropertySource = propertiesPropertySource;
        this.propertySources = this.build(propertiesPropertySource, JVM_ARGS_PROPERTY_SOURCE, SYSTEM_ENV_PROPERTY_SOURCE, DEFAULT_SETTING_PROPERTY_SOURCE);
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.search(key, String.class).orElse(defaultValue);
    }

    @Override
    public String getPropertyFrom(SourceType source, String key) {
        if (source == null) {
            return this.getProperty(key);
        }
        switch (source) {
            case JVM: {
                return JVM_ARGS_PROPERTY_SOURCE.getProperty(key);
            }
            case ENV: {
                return SYSTEM_ENV_PROPERTY_SOURCE.getProperty(key);
            }
            case PROPERTIES: {
                return this.propertiesPropertySource.getProperty(key);
            }
            case DEFAULT_SETTING: {
                return DEFAULT_SETTING_PROPERTY_SOURCE.getProperty(key);
            }
        }
        return this.getProperty(key);
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.search(key, Boolean.class).orElse(defaultValue);
    }

    @Override
    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        return this.search(key, Integer.class).orElse(defaultValue);
    }

    @Override
    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        return this.search(key, Long.class).orElse(defaultValue);
    }

    @Override
    public void setProperty(String key, String value) {
        this.propertiesPropertySource.setProperty(key, value);
    }

    @Override
    public void addProperties(Properties properties) {
        this.propertiesPropertySource.addProperties(properties);
    }

    @Override
    public Properties asProperties() {
        Properties properties = new Properties();
        ListIterator<AbstractPropertySource> iterator = this.propertySources.listIterator(this.propertySources.size());
        while (iterator.hasPrevious()) {
            AbstractPropertySource previous = iterator.previous();
            properties.putAll((Map<?, ?>)previous.asProperties());
        }
        return properties;
    }

    @Override
    public boolean containsKey(String key) {
        for (AbstractPropertySource propertySource : this.propertySources) {
            boolean containing = propertySource.containsKey(key);
            if (!containing) continue;
            return true;
        }
        return false;
    }

    private <T> Optional<T> search(String key, Class<T> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("target type must not be null!");
        }
        for (AbstractPropertySource propertySource : this.propertySources) {
            String value = propertySource.getProperty(key);
            if (value == null) continue;
            if (String.class.isAssignableFrom(targetType)) {
                try {
                    return Optional.of(value);
                }
                catch (Exception e) {
                    LOGGER.error("target type convert error", (Throwable)e);
                    return Optional.empty();
                }
            }
            return Optional.ofNullable(CONVERTER.convert(value, targetType));
        }
        return Optional.empty();
    }

    private List<AbstractPropertySource> build(AbstractPropertySource ... propertySources) {
        Map<SourceType, AbstractPropertySource> sourceMap = Arrays.stream(propertySources).collect(Collectors.toMap(AbstractPropertySource::getType, propertySource -> propertySource));
        return SEARCH_ORDER.stream().map(sourceMap::get).collect(Collectors.toList());
    }

    @Override
    public NacosClientProperties derive() {
        return new SearchableProperties(new PropertiesPropertySource(this.propertiesPropertySource));
    }

    @Override
    public NacosClientProperties derive(Properties properties) {
        NacosClientProperties nacosClientProperties = this.derive();
        nacosClientProperties.addProperties(properties);
        return nacosClientProperties;
    }

    static {
        CONVERTER = new CompositeConverter();
        List<SourceType> initOrder = Arrays.asList(SourceType.PROPERTIES, SourceType.JVM, SourceType.ENV, SourceType.DEFAULT_SETTING);
        String firstEnv = JVM_ARGS_PROPERTY_SOURCE.getProperty("nacos.env.first");
        if (StringUtils.isBlank(firstEnv)) {
            firstEnv = SYSTEM_ENV_PROPERTY_SOURCE.getProperty("nacos.env.first");
        }
        if (StringUtils.isNotBlank(firstEnv)) {
            try {
                SourceType sourceType = SourceType.valueOf(firstEnv.toUpperCase());
                if (!sourceType.equals((Object)SourceType.PROPERTIES) && !sourceType.equals((Object)SourceType.DEFAULT_SETTING)) {
                    int index = initOrder.indexOf((Object)sourceType);
                    SourceType replacedSourceType = initOrder.set(0, sourceType);
                    initOrder.set(index, replacedSourceType);
                }
            }
            catch (Exception e) {
                LOGGER.warn("first source type parse error, it will be used default order!", (Throwable)e);
            }
        }
        SEARCH_ORDER = initOrder;
        StringBuilder orderInfo = new StringBuilder("properties search order:");
        for (int i = 0; i < SEARCH_ORDER.size(); ++i) {
            orderInfo.append(SEARCH_ORDER.get(i).toString());
            if (i >= SEARCH_ORDER.size() - 1) continue;
            orderInfo.append("->");
        }
        LOGGER.debug(orderInfo.toString());
        INSTANCE = new SearchableProperties();
    }
}

