/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.common.conf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.utils.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSFileDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(TSFileDescriptor.class);
    private final TSFileConfig conf = new TSFileConfig();

    TSFileDescriptor() {
        this.init();
    }

    public static TSFileDescriptor getInstance() {
        return TsfileDescriptorHolder.INSTANCE;
    }

    public TSFileConfig getConfig() {
        return this.conf;
    }

    private void init() {
        Properties properties = this.loadProperties();
        if (properties != null) {
            this.overwriteConfigByCustomSettings(properties);
        }
    }

    public void overwriteConfigByCustomSettings(Properties properties) {
        PropertiesOverWriter writer = new PropertiesOverWriter(properties);
        writer.setInt(this.conf::setGroupSizeInByte, "group_size_in_byte");
        writer.setInt(this.conf::setPageSizeInByte, "page_size_in_byte");
        if (this.conf.getPageSizeInByte() > this.conf.getGroupSizeInByte()) {
            int groupSizeInByte = this.conf.getGroupSizeInByte();
            logger.warn("page_size is greater than group size, will set it as the same with group size {}", (Object)groupSizeInByte);
            this.conf.setPageSizeInByte(groupSizeInByte);
        }
        writer.setInt(this.conf::setMaxNumberOfPointsInPage, "max_number_of_points_in_page");
        writer.setInt(this.conf::setMaxDegreeOfIndexNode, "max_degree_of_index_node");
        writer.setInt(this.conf::setMaxStringLength, "max_string_length");
        writer.setInt(this.conf::setFloatPrecision, "float_precision");
        writer.setString(this.conf::setTimeEncoder, "time_encoder");
        writer.setString(this.conf::setValueEncoder, "value_encoder");
        writer.setString(this.conf::setCompressor, "compressor");
        writer.setInt(this.conf::setBatchSize, "batch_size");
    }

    private Properties loadProperties() {
        String file = this.detectPropertiesFile();
        if (file != null) {
            logger.info("try loading {} from {}", (Object)"iotdb-engine.properties", (Object)file);
            return this.loadPropertiesFromFile(file);
        }
        logger.warn("not found {}, use the default configs.", (Object)"iotdb-engine.properties");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadPropertiesFromFile(String filePath) {
        try (FileInputStream fileInputStream = new FileInputStream(filePath);){
            Properties properties2 = new Properties();
            properties2.load(fileInputStream);
            Properties properties = properties2;
            return properties;
        }
        catch (FileNotFoundException e) {
            logger.warn("Fail to find config file {}", (Object)filePath);
            return null;
        }
        catch (IOException e) {
            logger.warn("read file ({}) failure, please check the access permissions.", (Object)filePath);
            return null;
        }
    }

    private String detectPropertiesFile() {
        String confDirectory = System.getProperty("TSFILE_CONF");
        if (confDirectory != null) {
            return Paths.get(confDirectory, "iotdb-engine.properties").toAbsolutePath().toString();
        }
        String tsFileHome = System.getProperty("TSFILE_HOME");
        if (tsFileHome != null) {
            return Paths.get(tsFileHome, "conf", "iotdb-engine.properties").toAbsolutePath().toString();
        }
        return this.detectPropertiesFromClassPath();
    }

    private static URL getResource(String filename, ClassLoader classLoader) {
        return Loader.getResource(filename, classLoader);
    }

    private String detectPropertiesFromClassPath() {
        ClassLoader classLoader = Loader.getClassLoaderOfObject(this);
        URL u = TSFileDescriptor.getResource("iotdb-engine.properties", classLoader);
        if (u == null) {
            return null;
        }
        this.multiplicityWarning("iotdb-engine.properties", classLoader);
        return u.getFile();
    }

    private void multiplicityWarning(String resource, ClassLoader classLoader) {
        try {
            Set<URL> urlSet = Loader.getResources(resource, classLoader);
            if (urlSet != null && urlSet.size() > 1) {
                logger.warn("Resource [{}] occurs multiple times on the classpath", (Object)resource);
                for (URL url : urlSet) {
                    logger.warn("Resource [{}] occurs at [{}]", (Object)resource, (Object)url);
                }
            }
        }
        catch (IOException e) {
            logger.error("Failed to get url list for {}", (Object)resource);
        }
    }

    private static class TsfileDescriptorHolder {
        private static final TSFileDescriptor INSTANCE = new TSFileDescriptor();

        private TsfileDescriptorHolder() {
            throw new IllegalAccessError("Utility class");
        }
    }

    private class PropertiesOverWriter {
        private final Properties properties;

        public PropertiesOverWriter(Properties properties) {
            if (properties == null) {
                throw new NullPointerException("properties should not be null");
            }
            this.properties = properties;
        }

        public void setInt(Consumer<Integer> setter, String propertyKey) {
            this.set(setter, propertyKey, Integer::parseInt);
        }

        public void setString(Consumer<String> setter, String propertyKey) {
            this.set(setter, propertyKey, Function.identity());
        }

        private <T> void set(Consumer<T> setter, String propertyKey, Function<String, T> propertyValueConverter) {
            String value = this.properties.getProperty(propertyKey);
            if (value != null) {
                try {
                    T v = propertyValueConverter.apply(value);
                    setter.accept(v);
                }
                catch (Exception e) {
                    logger.warn("invalid value for {}, use the default value", (Object)propertyKey);
                }
            }
        }
    }
}

