/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

public class StrBuffer {
    private static final String POSITIVE_INF = "+inf";
    private static final String NEGATIVE_INF = "-inf";
    private static final long POSITIVE_INF_VALUE = 0x7FF0000000000000L;
    private static final long NEGATIVE_INF_VALUE = -4503599627370496L;
    private final char[] chars;
    private int left;
    private int right;

    public StrBuffer(String s) {
        this.chars = s.toCharArray();
        this.left = 0;
        this.right = s.length() - 1;
    }

    public char read() {
        if (this.left > this.right) {
            throw new IndexOutOfBoundsException("StrBuffer use charAt method error. left=" + this.left + ", right=" + this.right);
        }
        return this.chars[this.left++];
    }

    public void rollback() {
        if (this.left > 0) {
            --this.left;
        }
    }

    public char charAt(int i) {
        if (this.left + i > this.right) {
            throw new IndexOutOfBoundsException("StrBuffer use charAt method error. left=" + this.left + ", i=" + i);
        }
        return this.chars[this.left + i];
    }

    public String toStr() {
        StringBuilder builder = new StringBuilder();
        for (int i = this.left; i <= this.right; ++i) {
            builder.append(this.chars[i]);
        }
        return builder.toString();
    }

    public double toDouble() {
        String s = this.toStr();
        return StrBuffer.parseDouble(s);
    }

    public long toLong() {
        String s = this.toStr();
        return StrBuffer.parseLong(s);
    }

    public void skipBlankTabs() {
        while (this.left <= this.right && this.isBlankOrTab(this.chars[this.left])) {
            ++this.left;
        }
        while (this.right >= this.left && this.isBlankOrTab(this.chars[this.right])) {
            --this.right;
        }
    }

    private boolean isBlankOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    public boolean isEmpty() {
        return this.left > this.right;
    }

    public static long parseLong(String s) {
        if (POSITIVE_INF.equalsIgnoreCase(s)) {
            return 0x7FF0000000000000L;
        }
        if (NEGATIVE_INF.equalsIgnoreCase(s)) {
            return -4503599627370496L;
        }
        return Double.valueOf(s).longValue();
    }

    public static double parseDouble(String s) {
        if (POSITIVE_INF.equalsIgnoreCase(s)) {
            return 9.218868437227405E18;
        }
        if (NEGATIVE_INF.equalsIgnoreCase(s)) {
            return -4.503599627370496E15;
        }
        return Double.parseDouble(s);
    }
}

