/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.rpc.interceptors;

import com.codahale.metrics.Counter;
import com.google.protobuf.MessageLite;
import io.greptime.common.util.MetricsUtil;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class MetricInterceptor
implements ClientInterceptor {
    private static final String REQ_TYPE = "req";
    private static final String RESP_TYPE = "resp";
    private static final String QPS = "qps";
    private static final String BYTES = "bytes";
    private static final String SERIALIZED_BYTES = "serialized_bytes";
    private static final Counter REQ_BYTES = MetricsUtil.counter((Object[])new Object[]{"req", "bytes"});
    private static final Counter RESP_BYTES = MetricsUtil.counter((Object[])new Object[]{"resp", "bytes"});

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOpts, Channel next) {
        final String methodName = method.getFullMethodName();
        MetricsUtil.meter((Object[])new Object[]{REQ_TYPE, QPS, methodName}).mark();
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOpts)){

            public void start(ClientCall.Listener<RespT> respListener, Metadata headers) {
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(respListener){

                    public void onMessage(RespT msg) {
                        if (msg instanceof MessageLite) {
                            int size = ((MessageLite)msg).getSerializedSize();
                            MetricsUtil.histogram((Object[])new Object[]{MetricInterceptor.RESP_TYPE, MetricInterceptor.SERIALIZED_BYTES, methodName}).update(size);
                            RESP_BYTES.inc((long)size);
                        }
                        super.onMessage(msg);
                    }
                }, headers);
            }

            public void sendMessage(ReqT msg) {
                if (msg instanceof MessageLite) {
                    int size = ((MessageLite)msg).getSerializedSize();
                    MetricsUtil.histogram((Object[])new Object[]{MetricInterceptor.REQ_TYPE, MetricInterceptor.SERIALIZED_BYTES, methodName}).update(size);
                    REQ_BYTES.inc((long)size);
                }
                super.sendMessage(msg);
            }
        };
    }
}

