/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Objects;
import org.apache.hertzbeat.alert.service.AlertGroupConvergeService;
import org.apache.hertzbeat.common.entity.alerter.AlertGroupConverge;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Alert Converge API")
@RestController
@RequestMapping(path={"/api/alert/group"}, produces={"application/json"})
public class AlertGroupConvergeController {
    @Autowired
    private AlertGroupConvergeService alertGroupConvergeService;

    @PostMapping
    @Operation(summary="New Alarm Group Converge", description="Added an alarm Group Converge")
    public ResponseEntity<Message<Void>> addNewAlertGroupConverge(@Valid @RequestBody AlertGroupConverge alertGroupConverge) {
        this.alertGroupConvergeService.validate(alertGroupConverge, false);
        this.alertGroupConvergeService.addAlertGroupConverge(alertGroupConverge);
        return ResponseEntity.ok((Object)Message.success((String)"Add success"));
    }

    @PutMapping
    @Operation(summary="Modifying an Alarm Group Converge", description="Modify an existing alarm Group Converge")
    public ResponseEntity<Message<Void>> modifyAlertGroupConverge(@Valid @RequestBody AlertGroupConverge alertGroupConverge) {
        this.alertGroupConvergeService.validate(alertGroupConverge, true);
        this.alertGroupConvergeService.modifyAlertGroupConverge(alertGroupConverge);
        return ResponseEntity.ok((Object)Message.success((String)"Modify success"));
    }

    @GetMapping(path={"/{id}"})
    @Operation(summary="Querying Alarm Group Converge", description="You can obtain alarm Group Converge information based on the alarm Converge ID")
    public ResponseEntity<Message<AlertGroupConverge>> getAlertGroupConverge(@Parameter(description="Alarm Converge ID", example="6565463543") @PathVariable(value="id") long id) {
        AlertGroupConverge alertGroupConverge = this.alertGroupConvergeService.getAlertGroupConverge(id);
        return Objects.isNull(alertGroupConverge) ? ResponseEntity.ok((Object)Message.fail((byte)3, (String)"Alert Group Converge not exist.")) : ResponseEntity.ok((Object)Message.success((Object)alertGroupConverge));
    }
}

