/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.pop3;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.pop3.POP3Client;
import org.apache.commons.net.pop3.POP3MessageInfo;
import org.apache.commons.net.pop3.POP3SClient;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.Pop3Protocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pop3CollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(Pop3CollectImpl.class);
    private static final String EMAIL_COUNT = "email_count";
    private static final String MAILBOX_SIZE = "mailbox_size";

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        Pop3Protocol pop3Protocol;
        if (metrics == null || (pop3Protocol = metrics.getPop3()) == null || pop3Protocol.isInvalid()) {
            throw new IllegalArgumentException("Pop3 collect must has pop3 params");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        String errorMsg;
        long startTime = System.currentTimeMillis();
        Pop3Protocol pop3Protocol = metrics.getPop3();
        POP3Client pop3Client = null;
        boolean ssl = Boolean.parseBoolean(pop3Protocol.getSsl());
        try {
            pop3Client = this.createPOP3Client(pop3Protocol, ssl);
            if (pop3Client.isConnected()) {
                long responseTime = System.currentTimeMillis() - startTime;
                this.obtainPop3Metrics(builder, pop3Client, metrics.getAliasFields(), responseTime);
            } else {
                builder.setCode(CollectRep.Code.UN_CONNECTABLE);
                builder.setMsg("Peer connect failed\uff0cTimeout " + pop3Protocol.getTimeout() + "ms");
            }
        }
        catch (Exception e2) {
            errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e2);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        finally {
            if (pop3Client != null) {
                try {
                    pop3Client.logout();
                    pop3Client.disconnect();
                }
                catch (IOException e) {
                    errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
                    log.info(errorMsg);
                    builder.setCode(CollectRep.Code.FAIL);
                    builder.setMsg(errorMsg);
                }
            }
        }
    }

    public String supportProtocol() {
        return "pop3";
    }

    private POP3Client createPOP3Client(Pop3Protocol pop3Protocol, boolean ssl) throws Exception {
        Object pop3Client = null;
        pop3Client = ssl ? new POP3SClient(true) : new POP3Client();
        int timeout = Integer.parseInt(pop3Protocol.getTimeout());
        if (timeout > 0) {
            pop3Client.setConnectTimeout(timeout);
        }
        pop3Client.setCharset(StandardCharsets.UTF_8);
        String host = pop3Protocol.getHost();
        int port = Integer.parseInt(pop3Protocol.getPort());
        pop3Client.connect(host, port);
        String email = pop3Protocol.getEmail();
        String authorize = pop3Protocol.getAuthorize();
        boolean isAuthenticated = pop3Client.login(email, authorize);
        if (!isAuthenticated) {
            throw new Exception("Pop3 client authentication failed");
        }
        return pop3Client;
    }

    private void obtainPop3Metrics(CollectRep.MetricsData.Builder builder, POP3Client pop3Client, List<String> aliasFields, long responseTime) throws IOException {
        Map<String, Object> pop3Metrics = this.parsePop3Metrics(pop3Client, aliasFields);
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        for (String alias : aliasFields) {
            Object value = pop3Metrics.get(alias);
            if (value != null) {
                valueRowBuilder.addColumn(String.valueOf(value));
                continue;
            }
            if ("responseTime".equalsIgnoreCase(alias)) {
                valueRowBuilder.addColumn(String.valueOf(responseTime));
                continue;
            }
            valueRowBuilder.addColumn("&nbsp;");
        }
        builder.addValueRow(valueRowBuilder.build());
    }

    private Map<String, Object> parsePop3Metrics(POP3Client pop3Client, List<String> aliasFields) throws IOException {
        HashMap<String, Object> pop3Metrics = new HashMap<String, Object>(aliasFields.size());
        POP3MessageInfo status = pop3Client.status();
        int emailCount = 0;
        double mailboxSize = 0.0;
        if (status != null) {
            emailCount = status.number;
            mailboxSize = (double)status.size / 1024.0;
            pop3Metrics.put(EMAIL_COUNT, emailCount);
            pop3Metrics.put(MAILBOX_SIZE, mailboxSize);
        }
        return pop3Metrics;
    }
}

