/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import com.google.auto.value.AutoValue;
import io.opentelemetry.instrumentation.jdbc.internal.AutoValue_DbRequest;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcData;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcUtils;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;

@AutoValue
public abstract class DbRequest {
    @Nullable
    public static DbRequest create(PreparedStatement statement) {
        return DbRequest.create(statement, (String)JdbcData.preparedStatement.get((Object)statement));
    }

    @Nullable
    public static DbRequest create(Statement statement, String dbStatementString) {
        return DbRequest.create(statement, dbStatementString, null);
    }

    @Nullable
    public static DbRequest create(Statement statement, String dbStatementString, Long batchSize) {
        Connection connection = JdbcUtils.connectionFromStatement(statement);
        if (connection == null) {
            return null;
        }
        return DbRequest.create(JdbcUtils.extractDbInfo(connection), dbStatementString, batchSize);
    }

    public static DbRequest create(Statement statement, Collection<String> queryTexts, Long batchSize) {
        Connection connection = JdbcUtils.connectionFromStatement(statement);
        if (connection == null) {
            return null;
        }
        return DbRequest.create(JdbcUtils.extractDbInfo(connection), queryTexts, batchSize);
    }

    public static DbRequest create(DbInfo dbInfo, String queryText) {
        return DbRequest.create(dbInfo, queryText, null);
    }

    public static DbRequest create(DbInfo dbInfo, String queryText, Long batchSize) {
        return DbRequest.create(dbInfo, Collections.singletonList(queryText), batchSize);
    }

    public static DbRequest create(DbInfo dbInfo, Collection<String> queryTexts, Long batchSize) {
        return new AutoValue_DbRequest(dbInfo, queryTexts, batchSize);
    }

    public abstract DbInfo getDbInfo();

    public abstract Collection<String> getQueryTexts();

    @Nullable
    public abstract Long getBatchSize();
}

