/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.log;

import dm.jdbc.filter.log.LogRecord$NullData;
import dm.jdbc.filter.log.Logger;

class LogRecord {
    public static final LogRecord$NullData NULL = new LogRecord$NullData();
    private String source;
    private String method;
    private Object[] params;
    private Object returnValue;
    private Throwable e;
    private long usedTime;
    private String sql;

    public LogRecord(Object object, String string, Object ... objectArray) {
        this.source = Logger.formatSource(object);
        this.method = string;
        this.params = objectArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(Logger.formatTrace((Object)this.source, this.method, this.returnValue, this.params));
        if (this.usedTime > 0L) {
            stringBuilder.append(this.formatUsedTime(this.usedTime));
        }
        return stringBuilder.toString();
    }

    private String formatUsedTime(long l2) {
        return "[USED TIME]: " + (double)l2 / 1000000.0 + "ms;";
    }

    public void setThrowable(Throwable throwable) {
        this.e = throwable;
    }

    public Throwable getThrowable() {
        return this.e;
    }

    public void setReturnValue(Object object) {
        this.returnValue = object == null ? NULL : object;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setUsedTime(long l2) {
        this.usedTime = l2;
    }

    public long getUsedTime() {
        return this.usedTime;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String string) {
        this.sql = string;
    }
}

