/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.Column;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSetMetaData;
import javax.sql.RowSetMetaData;

public class DmdbRowSetMetaData
extends DmdbResultSetMetaData
implements RowSetMetaData {
    private boolean[] m_autoIncr;
    private boolean[] m_caseSens;
    private String[] m_catalogName;
    private int m_columnCount;
    private int[] m_colDisplaySize;
    private String[] m_colDisplayLable;
    private String[] m_columnName;
    private String[] m_columnClassName;
    private int[] m_colSQLType;
    private String[] m_colTypeName;
    private boolean[] m_currency;
    private int[] m_nullable;
    private int[] m_precision;
    private int[] m_scale;
    private String[] m_schemaName;
    private boolean[] m_searchable;
    private boolean[] m_signed;
    private String[] m_tableName;
    private boolean[] m_readOnly;
    private boolean[] m_writeable;
    private boolean[] m_defWriteable;

    public DmdbRowSetMetaData(DmdbConnection dmdbConnection, Column[] columnArray) {
        super(dmdbConnection, columnArray);
        this.initializeProps();
    }

    private void initializeProps() {
        this.m_columnCount = super.do_getColumnCount();
        this.m_autoIncr = new boolean[this.m_columnCount];
        this.m_caseSens = new boolean[this.m_columnCount];
        this.m_catalogName = new String[this.m_columnCount];
        this.m_colDisplaySize = new int[this.m_columnCount];
        this.m_colDisplayLable = new String[this.m_columnCount];
        this.m_columnClassName = new String[this.m_columnCount];
        this.m_columnName = new String[this.m_columnCount];
        this.m_colSQLType = new int[this.m_columnCount];
        this.m_colTypeName = new String[this.m_columnCount];
        this.m_currency = new boolean[this.m_columnCount];
        this.m_nullable = new int[this.m_columnCount];
        this.m_precision = new int[this.m_columnCount];
        this.m_scale = new int[this.m_columnCount];
        this.m_schemaName = new String[this.m_columnCount];
        this.m_searchable = new boolean[this.m_columnCount];
        this.m_signed = new boolean[this.m_columnCount];
        this.m_tableName = new String[this.m_columnCount];
        this.m_readOnly = new boolean[this.m_columnCount];
        this.m_writeable = new boolean[this.m_columnCount];
        this.m_defWriteable = new boolean[this.m_columnCount];
        int n2 = 0;
        while (n2 < this.m_columnCount) {
            this.m_autoIncr[n2] = super.do_isAutoIncrement(n2 + 1);
            this.m_caseSens[n2] = super.do_isCaseSensitive(n2 + 1);
            this.m_catalogName[n2] = super.do_getCatalogName(n2 + 1);
            this.m_colDisplaySize[n2] = super.do_getColumnDisplaySize(n2 + 1);
            this.m_colDisplayLable[n2] = super.do_getColumnLabel(n2 + 1);
            this.m_columnClassName[n2] = super.do_getColumnClassName(n2 + 1);
            this.m_columnName[n2] = super.do_getColumnName(n2 + 1);
            this.m_colSQLType[n2] = super.do_getColumnType(n2 + 1);
            this.m_colTypeName[n2] = super.do_getColumnTypeName(n2 + 1);
            this.m_currency[n2] = super.do_isCurrency(n2 + 1);
            this.m_nullable[n2] = super.do_isNullable(n2 + 1);
            this.m_precision[n2] = super.do_getPrecision(n2 + 1);
            this.m_scale[n2] = super.do_getScale(n2 + 1);
            this.m_schemaName[n2] = super.do_getSchemaName(n2 + 1);
            this.m_searchable[n2] = super.do_isSearchable(n2 + 1);
            this.m_signed[n2] = super.do_isSigned(n2 + 1);
            this.m_tableName[n2] = super.do_getTableName(n2 + 1);
            this.m_readOnly[n2] = super.do_isReadOnly(n2 + 1);
            this.m_writeable[n2] = super.do_isWritable(n2 + 1);
            this.m_defWriteable[n2] = super.do_isDefinitelyWritable(n2 + 1);
            ++n2;
        }
    }

    private void checkColumn(int n2) {
        if (n2 < 1 || n2 > this.m_columnCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
        }
    }

    @Override
    public int getColumnCount() {
        return this.m_columnCount;
    }

    @Override
    public boolean isAutoIncrement(int n2) {
        this.checkColumn(n2);
        return this.m_autoIncr[n2 - 1];
    }

    @Override
    public boolean isCaseSensitive(int n2) {
        this.checkColumn(n2);
        return this.m_caseSens[n2 - 1];
    }

    @Override
    public boolean isSearchable(int n2) {
        this.checkColumn(n2);
        return this.m_searchable[n2 - 1];
    }

    @Override
    public boolean isCurrency(int n2) {
        this.checkColumn(n2);
        return this.m_currency[n2 - 1];
    }

    @Override
    public int isNullable(int n2) {
        this.checkColumn(n2);
        return this.m_nullable[n2 - 1];
    }

    @Override
    public boolean isSigned(int n2) {
        this.checkColumn(n2);
        return this.m_signed[n2 - 1];
    }

    @Override
    public int getColumnDisplaySize(int n2) {
        this.checkColumn(n2);
        return this.m_colDisplaySize[n2 - 1];
    }

    @Override
    public String getColumnLabel(int n2) {
        this.checkColumn(n2);
        return this.m_colDisplayLable[n2 - 1];
    }

    @Override
    public String getColumnName(int n2) {
        this.checkColumn(n2);
        return this.m_columnName[n2 - 1];
    }

    @Override
    public String getSchemaName(int n2) {
        this.checkColumn(n2);
        return this.m_schemaName[n2 - 1];
    }

    @Override
    public int getPrecision(int n2) {
        this.checkColumn(n2);
        return this.m_precision[n2 - 1];
    }

    @Override
    public int getScale(int n2) {
        this.checkColumn(n2);
        return this.m_scale[n2 - 1];
    }

    @Override
    public String getTableName(int n2) {
        this.checkColumn(n2);
        return this.m_tableName[n2 - 1];
    }

    @Override
    public String getCatalogName(int n2) {
        this.checkColumn(n2);
        return this.m_catalogName[n2 - 1];
    }

    @Override
    public int getColumnType(int n2) {
        this.checkColumn(n2);
        return this.m_colSQLType[n2 - 1];
    }

    @Override
    public String getColumnTypeName(int n2) {
        this.checkColumn(n2);
        return this.m_colTypeName[n2 - 1];
    }

    @Override
    public boolean isReadOnly(int n2) {
        this.checkColumn(n2);
        return this.m_readOnly[n2 - 1];
    }

    @Override
    public boolean isWritable(int n2) {
        this.checkColumn(n2);
        return this.m_writeable[n2 - 1];
    }

    @Override
    public boolean isDefinitelyWritable(int n2) {
        this.checkColumn(n2);
        return this.m_defWriteable[n2 - 1];
    }

    @Override
    public String getColumnClassName(int n2) {
        this.checkColumn(n2);
        return this.m_columnClassName[n2 - 1];
    }

    @Override
    public void setColumnCount(int n2) {
        this.m_columnCount = n2;
    }

    @Override
    public void setAutoIncrement(int n2, boolean bl) {
        this.checkColumn(n2);
        this.m_autoIncr[n2 - 1] = bl;
    }

    @Override
    public void setCaseSensitive(int n2, boolean bl) {
        this.checkColumn(n2);
        this.m_caseSens[n2 - 1] = bl;
    }

    @Override
    public void setSearchable(int n2, boolean bl) {
        this.checkColumn(n2);
        this.m_searchable[n2 - 1] = bl;
    }

    @Override
    public void setCurrency(int n2, boolean bl) {
        this.checkColumn(n2);
        this.m_currency[n2 - 1] = bl;
    }

    @Override
    public void setNullable(int n2, int n3) {
        this.checkColumn(n2);
        this.m_nullable[n2 - 1] = n3;
    }

    @Override
    public void setSigned(int n2, boolean bl) {
        this.checkColumn(n2);
        this.m_signed[n2 - 1] = bl;
    }

    @Override
    public void setColumnDisplaySize(int n2, int n3) {
        this.checkColumn(n2);
        this.m_colDisplaySize[n2 - 1] = n3;
    }

    @Override
    public void setColumnLabel(int n2, String string) {
        this.checkColumn(n2);
        this.m_colDisplayLable[n2 - 1] = string;
    }

    @Override
    public void setColumnName(int n2, String string) {
        this.checkColumn(n2);
        this.m_columnName[n2 - 1] = string;
    }

    @Override
    public void setSchemaName(int n2, String string) {
        this.checkColumn(n2);
        this.m_schemaName[n2 - 1] = string;
    }

    @Override
    public void setPrecision(int n2, int n3) {
        this.checkColumn(n2);
        this.m_precision[n2 - 1] = n3;
    }

    @Override
    public void setScale(int n2, int n3) {
        this.checkColumn(n2);
        this.m_scale[n2 - 1] = n3;
    }

    @Override
    public void setTableName(int n2, String string) {
        this.checkColumn(n2);
        this.m_tableName[n2 - 1] = string;
    }

    @Override
    public void setCatalogName(int n2, String string) {
        this.checkColumn(n2);
        this.m_catalogName[n2 - 1] = string;
    }

    @Override
    public void setColumnType(int n2, int n3) {
        this.checkColumn(n2);
        this.m_colSQLType[n2 - 1] = n3;
    }

    @Override
    public void setColumnTypeName(int n2, String string) {
        this.checkColumn(n2);
        this.m_colTypeName[n2 - 1] = string;
    }

    @Override
    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }
}

