/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.auditlog;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLog {
    private static Logger _logger = LoggerFactory.getLogger((String)AuditLog.class.getName());
    public static final String ATTRIBUTE_NAME = "AUDIT_LOG";
    private Date _startTime;
    private Date _completeTime;
    private Principal _principal;
    private String _clientIP;
    private String _clientHostPort;
    private String _namespace;
    private String _requestPath;
    private String _httpMethod;
    private List<String> _requestHeaders;
    private String _requestEntity;
    private int _responseCode;
    private String _responseEntity;
    private List<Exception> _exceptions;
    private String _additionalInfo;

    public AuditLog(Date startTime, Date completeTime, Principal principal, String clientIP, String clientHostPort, String namespace, String requestPath, String httpMethod, List<String> requestHeaders, String requestEntity, int responseCode, String responseEntity, String additionalInfo, List<Exception> exceptions) {
        this._startTime = startTime;
        this._completeTime = completeTime;
        this._principal = principal;
        this._clientIP = clientIP;
        this._clientHostPort = clientHostPort;
        this._namespace = namespace;
        this._requestPath = requestPath;
        this._httpMethod = httpMethod;
        this._requestHeaders = requestHeaders;
        this._requestEntity = requestEntity;
        this._responseCode = responseCode;
        this._responseEntity = responseEntity;
        this._additionalInfo = additionalInfo;
        this._exceptions = exceptions;
    }

    public String toString() {
        return "AuditLog{_startTime=" + this._startTime + ", _completeTime=" + this._completeTime + ", _principal=" + this._principal + ", _clientIP='" + this._clientIP + "', _clientHostPort='" + this._clientHostPort + "', _namespace='" + this._namespace + "', _requestPath='" + this._requestPath + "', _httpMethod='" + this._httpMethod + "', _requestHeaders=" + this._requestHeaders + ", _requestEntity='" + this._requestEntity + "', _responseCode=" + this._responseCode + ", _responseEntity='" + this._responseEntity + "', _exceptions=" + this._exceptions + ", _additionalInfo='" + this._additionalInfo + "'}";
    }

    public Date getStartTime() {
        return this._startTime;
    }

    public Date getCompleteTime() {
        return this._completeTime;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public String getClientIP() {
        return this._clientIP;
    }

    public String getClientHostPort() {
        return this._clientHostPort;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getRequestPath() {
        return this._requestPath;
    }

    public String getHttpMethod() {
        return this._httpMethod;
    }

    public List<String> getRequestHeaders() {
        return this._requestHeaders;
    }

    public String getRequestEntity() {
        return this._requestEntity;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public String getResponseEntity() {
        return this._responseEntity;
    }

    public List<Exception> getExceptions() {
        return this._exceptions;
    }

    public String getAdditionalInfo() {
        return this._additionalInfo;
    }

    public static class Builder {
        private Date _startTime;
        private Date _completeTime;
        private Principal _principal;
        private String _clientIP;
        private String _clientHostPort;
        private String _namespace;
        private String _requestPath;
        private String _httpMethod;
        private List<String> _requestHeaders;
        private String _requestEntity;
        private int _responseCode;
        private String _responseEntity;
        private List<Exception> _exceptions;
        private String _additionalInfo;

        public Date getStartTime() {
            return this._startTime;
        }

        public Builder startTime(Date startTime) {
            this._startTime = startTime;
            return this;
        }

        public Date getCompleteTime() {
            return this._completeTime;
        }

        public Builder completeTime(Date completeTime) {
            this._completeTime = completeTime;
            return this;
        }

        public Principal getPrincipal() {
            return this._principal;
        }

        public Builder principal(Principal principal) {
            this._principal = principal;
            return this;
        }

        public String getClientIP() {
            return this._clientIP;
        }

        public Builder clientIP(String clientIP) {
            this._clientIP = clientIP;
            return this;
        }

        public String getClientHostPort() {
            return this._clientHostPort;
        }

        public Builder clientHostPort(String clientHostPort) {
            this._clientHostPort = clientHostPort;
            return this;
        }

        public String getNamespace() {
            return this._namespace;
        }

        public Builder namespace(String namespace) {
            this._namespace = namespace;
            return this;
        }

        public String getRequestPath() {
            return this._requestPath;
        }

        public Builder requestPath(String requestPath) {
            this._requestPath = requestPath;
            return this;
        }

        public String getHttpMethod() {
            return this._httpMethod;
        }

        public Builder httpMethod(String httpMethod) {
            this._httpMethod = httpMethod;
            return this;
        }

        public String getRequestEntity() {
            return this._requestEntity;
        }

        public Builder requestEntity(String requestEntity) {
            this._requestEntity = requestEntity;
            return this;
        }

        public List<String> getRequestHeaders() {
            return this._requestHeaders;
        }

        public Builder requestHeaders(List<String> requestHeaders) {
            this._requestHeaders = requestHeaders;
            return this;
        }

        public int getResponseCode() {
            return this._responseCode;
        }

        public Builder responseCode(int responseCode) {
            this._responseCode = responseCode;
            return this;
        }

        public String getResponseEntity() {
            return this._responseEntity;
        }

        public Builder responseEntity(String responseEntity) {
            this._responseEntity = responseEntity;
            return this;
        }

        public List<Exception> getExceptions() {
            return this._exceptions;
        }

        public Builder exceptions(List<Exception> exceptions) {
            this._exceptions = exceptions;
            return this;
        }

        public Builder addException(Exception ex) {
            if (this._exceptions == null) {
                this._exceptions = new ArrayList<Exception>();
            }
            this._exceptions.add(ex);
            return this;
        }

        public String getAdditionalInfo() {
            return this._additionalInfo;
        }

        public Builder additionalInfo(String additionalInfo) {
            this._additionalInfo = additionalInfo;
            return this;
        }

        public AuditLog build() {
            return new AuditLog(this._startTime, this._completeTime, this._principal, this._clientIP, this._clientHostPort, this._namespace, this._requestPath, this._httpMethod, this._requestHeaders, this._requestEntity, this._responseCode, this._responseEntity, this._additionalInfo, this._exceptions);
        }
    }
}

