/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.helix.HelixManager;
import org.apache.helix.NotificationContext;
import org.apache.helix.common.DedupEventBlockingQueue;
import org.apache.helix.manager.zk.CallbackEventThreadPoolFactory;
import org.apache.helix.manager.zk.CallbackHandler;
import org.apache.helix.zookeeper.zkclient.exception.ZkInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackEventExecutor {
    private static Logger logger = LoggerFactory.getLogger(CallbackHandler.class);
    private DedupEventBlockingQueue<NotificationContext.Type, NotificationContext> _callBackEventQueue = new DedupEventBlockingQueue();
    private final HelixManager _manager;
    private Future _futureCallBackProcessEvent = null;
    private ThreadPoolExecutor _threadPoolExecutor;
    private boolean _isShutdown = false;

    public CallbackEventExecutor(HelixManager manager) {
        this._manager = manager;
        this._threadPoolExecutor = CallbackEventThreadPoolFactory.getOrCreateThreadPool(manager.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitEventToExecutor(NotificationContext.Type eventType, NotificationContext event, CallbackHandler handler) {
        DedupEventBlockingQueue<NotificationContext.Type, NotificationContext> dedupEventBlockingQueue = this._callBackEventQueue;
        synchronized (dedupEventBlockingQueue) {
            if (this._isShutdown) {
                logger.error("Failed to process callback. CallbackEventExecutor is already shut down.");
            }
            if (this._futureCallBackProcessEvent == null || this._futureCallBackProcessEvent.isDone()) {
                this._futureCallBackProcessEvent = this._threadPoolExecutor.submit(new CallbackProcessor(handler, event));
            } else {
                this._callBackEventQueue.put(eventType, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitPendingHandleCallBackEventToManagerThreadPool(CallbackHandler handler) {
        DedupEventBlockingQueue<NotificationContext.Type, NotificationContext> dedupEventBlockingQueue = this._callBackEventQueue;
        synchronized (dedupEventBlockingQueue) {
            if (this._callBackEventQueue.size() != 0) {
                try {
                    NotificationContext event = this._callBackEventQueue.take();
                    this._futureCallBackProcessEvent = this._threadPoolExecutor.submit(new CallbackProcessor(handler, event));
                }
                catch (InterruptedException e) {
                    logger.error("Error when submitting pending HandleCallBackEvent to manager thread pool", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DedupEventBlockingQueue<NotificationContext.Type, NotificationContext> dedupEventBlockingQueue = this._callBackEventQueue;
        synchronized (dedupEventBlockingQueue) {
            this._callBackEventQueue.clear();
            if (this._futureCallBackProcessEvent != null) {
                this._futureCallBackProcessEvent.cancel(false);
            }
        }
    }

    public void unregisterFromFactory() {
        this._isShutdown = true;
        this.reset();
        CallbackEventThreadPoolFactory.unregisterEventProcessor(this._manager.hashCode());
        this._threadPoolExecutor = null;
    }

    class CallbackProcessor
    implements Runnable {
        private final CallbackHandler _handler;
        protected final String _processorName;
        private final NotificationContext _event;

        public CallbackProcessor(CallbackHandler handler, NotificationContext event) {
            this._processorName = CallbackEventExecutor.this._manager.getClusterName() + "-CallbackProcessor@" + Integer.toHexString(handler.hashCode());
            this._handler = handler;
            this._event = event;
        }

        @Override
        public void run() {
            try {
                this._handler.invoke(this._event);
            }
            catch (ZkInterruptedException e) {
                logger.warn(this._processorName + " thread caught a ZK connection interrupt", (Throwable)e);
            }
            catch (ThreadDeath death) {
                logger.error(this._processorName + " thread dead " + this._processorName, (Throwable)death);
            }
            catch (Throwable t) {
                logger.error(this._processorName + " thread failed while running " + this._processorName, t);
            }
            CallbackEventExecutor.this.submitPendingHandleCallBackEventToManagerThreadPool(this._handler);
        }
    }
}

