/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.util.Map;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(ConstraintResource.class);

    public ConstraintResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation representation = null;
        String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
        String constraintTypeStr = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CONSTRAINT_TYPE);
        String constraintId = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CONSTRAINT_ID);
        try {
            ClusterConstraints.ConstraintType constraintType = ClusterConstraints.ConstraintType.valueOf((String)constraintTypeStr);
            ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
            ZKHelixAdmin admin = new ZKHelixAdmin((RealmAwareZkClient)zkClient);
            ZNRecord record = admin.getConstraints(clusterName, constraintType).getRecord();
            if (constraintId == null) {
                representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(record), MediaType.APPLICATION_JSON);
            } else {
                Map constraint = record.getMapField(constraintId);
                if (constraint == null) {
                    representation = new StringRepresentation((CharSequence)("No constraint of type: " + constraintType + " associated with id: " + constraintId), MediaType.APPLICATION_JSON);
                } else {
                    ZNRecord subRecord = new ZNRecord(record.getId());
                    subRecord.setMapField(constraintId, constraint);
                    representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(subRecord), MediaType.APPLICATION_JSON);
                }
            }
        }
        catch (IllegalArgumentException e) {
            representation = new StringRepresentation((CharSequence)("constraint-type: " + constraintTypeStr + " not recognized."), MediaType.APPLICATION_JSON);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            representation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("Exception get constraints", (Throwable)e);
        }
        return representation;
    }

    public Representation post(Representation entity) {
        String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
        String constraintTypeStr = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CONSTRAINT_TYPE);
        String constraintId = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CONSTRAINT_ID);
        try {
            ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
            ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkClient);
            JsonParameters jsonParameters = new JsonParameters(entity);
            String constraintAttrStr = jsonParameters.getParameter("constraintAttributes");
            setupTool.setConstraint(clusterName, constraintTypeStr, constraintId, constraintAttrStr);
        }
        catch (Exception e) {
            LOG.error("Error in posting " + entity, (Throwable)e);
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        return null;
    }

    public Representation delete() {
        String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
        String constraintTypeStr = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CONSTRAINT_TYPE);
        String constraintId = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CONSTRAINT_ID);
        try {
            ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
            ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkClient);
            setupTool.removeConstraint(clusterName, constraintTypeStr, constraintId);
        }
        catch (Exception e) {
            LOG.error("Error in delete constraint", (Throwable)e);
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        return null;
    }
}

