/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.common;

import java.util.HashMap;
import java.util.Map;

public class HelixRestNamespace {
    public static final String DEFAULT_NAMESPACE_PATH_SPEC = "/*";
    public static final String DEFAULT_NAMESPACE_NAME = "default";
    private String _name;
    private HelixMetadataStoreType _metadataStoreType;
    private String _metadataStoreAddress;
    private boolean _isDefault;
    private boolean _isMultiZkEnabled;
    private String _msdsEndpoint;

    public HelixRestNamespace(String metadataStoreAddress) throws IllegalArgumentException {
        this(DEFAULT_NAMESPACE_NAME, HelixMetadataStoreType.ZOOKEEPER, metadataStoreAddress, true);
    }

    public HelixRestNamespace(String name, HelixMetadataStoreType metadataStoreType, String metadataStoreAddress, boolean isDefault) throws IllegalArgumentException {
        this(name, metadataStoreType, metadataStoreAddress, isDefault, false, null);
    }

    public HelixRestNamespace(String name, HelixMetadataStoreType metadataStoreType, String metadataStoreAddress, boolean isDefault, boolean isMultiZkEnabled, String msdsEndpoint) {
        this._name = name;
        this._metadataStoreAddress = metadataStoreAddress;
        this._metadataStoreType = metadataStoreType;
        this._isDefault = isDefault;
        this._isMultiZkEnabled = isMultiZkEnabled;
        this._msdsEndpoint = msdsEndpoint;
        this.validate();
    }

    private void validate() throws IllegalArgumentException {
        if (this._name == null || this._name.length() == 0) {
            throw new IllegalArgumentException("Name of namespace not provided");
        }
        if (this._metadataStoreType != HelixMetadataStoreType.NO_METADATA_STORE && (this._metadataStoreAddress == null || this._metadataStoreAddress.isEmpty())) {
            throw new IllegalArgumentException(String.format("Metadata store address \"%s\" is not valid for namespace %s", this._metadataStoreAddress, this._name));
        }
    }

    public boolean isDefault() {
        return this._isDefault;
    }

    public String getName() {
        return this._name;
    }

    public String getMetadataStoreAddress() {
        return this._metadataStoreAddress;
    }

    public Map<String, String> getRestInfo() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(HelixRestNamespaceProperty.NAME.name(), this._name);
        ret.put(HelixRestNamespaceProperty.IS_DEFAULT.name(), String.valueOf(this._isDefault));
        ret.put(HelixRestNamespaceProperty.MULTI_ZK_ENABLED.name(), String.valueOf(this._isMultiZkEnabled));
        ret.put(HelixRestNamespaceProperty.MSDS_ENDPOINT.name(), String.valueOf(this._msdsEndpoint));
        return ret;
    }

    public boolean isMultiZkEnabled() {
        return this._isMultiZkEnabled;
    }

    public String getMsdsEndpoint() {
        return this._msdsEndpoint;
    }

    public static enum HelixRestNamespaceProperty {
        NAME,
        METADATA_STORE_TYPE,
        METADATA_STORE_ADDRESS,
        IS_DEFAULT,
        MULTI_ZK_ENABLED,
        MSDS_ENDPOINT;

    }

    public static enum HelixMetadataStoreType {
        ZOOKEEPER,
        NO_METADATA_STORE;

    }
}

