/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixStateTransitionCancellationHandler
extends MessageHandler {
    private final StateModel _stateModel;
    private static final Logger logger = LoggerFactory.getLogger(HelixStateTransitionCancellationHandler.class);

    public HelixStateTransitionCancellationHandler(StateModel stateModel, Message message, NotificationContext context) {
        super(message, context);
        this._stateModel = stateModel;
    }

    @Override
    public HelixTaskResult handleMessage() throws InterruptedException {
        HelixTaskResult taskResult = new HelixTaskResult();
        try {
            this._stateModel.cancel();
            taskResult.setSuccess(true);
        }
        catch (Exception e) {
            taskResult.setSuccess(false);
            taskResult.setMessage(e.toString());
            taskResult.setException(e);
        }
        return taskResult;
    }

    @Override
    public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
        logger.warn("No extra action needed when cancel failed.");
    }
}

