/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.rest.client.CustomRestClient;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CustomRestClientImpl
implements CustomRestClient {
    private static final Logger LOG = LoggerFactory.getLogger(CustomRestClientImpl.class);
    private static final String INSTANCE_HEALTH_STATUS = "/instanceHealthStatus";
    private static final String PARTITION_HEALTH_STATUS = "/partitionHealthStatus";
    private static final String IS_HEALTHY_FIELD = "IS_HEALTHY";
    private static final String PARTITIONS = "partitions";
    private static final String ACCEPT_CONTENT_TYPE = "application/json";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private HttpClient _httpClient;

    public CustomRestClientImpl(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    @Override
    public Map<String, Boolean> getInstanceStoppableCheck(String baseUrl, Map<String, String> customPayloads) throws IOException {
        String url = baseUrl + INSTANCE_HEALTH_STATUS;
        JsonConverter jsonConverter = jsonNode -> {
            HashMap result = new HashMap();
            jsonNode.fields().forEachRemaining(kv -> result.put(kv.getKey(), ((JsonNode)kv.getValue()).asBoolean()));
            return result;
        };
        return this.handleResponse(this.post(url, Collections.unmodifiableMap(customPayloads)), jsonConverter);
    }

    @Override
    public Map<String, Boolean> getPartitionStoppableCheck(String baseUrl, List<String> partitions, Map<String, String> customPayloads) throws IOException {
        String url = baseUrl + PARTITION_HEALTH_STATUS;
        HashMap<String, Object> payLoads = new HashMap<String, Object>(customPayloads);
        if (partitions != null) {
            payLoads.put(PARTITIONS, partitions);
        }
        JsonConverter jsonConverter = jsonNode -> {
            HashMap result = new HashMap();
            jsonNode.fields().forEachRemaining(kv -> result.put(kv.getKey(), ((JsonNode)kv.getValue()).get(IS_HEALTHY_FIELD).asBoolean()));
            return result;
        };
        return this.handleResponse(this.post(url, payLoads), jsonConverter);
    }

    @VisibleForTesting
    protected JsonNode getJsonObject(HttpResponse httpResponse) throws IOException {
        HttpEntity httpEntity = httpResponse.getEntity();
        String str = EntityUtils.toString((HttpEntity)httpEntity);
        LOG.info("Converting Response Content {} to JsonNode", (Object)str);
        return OBJECT_MAPPER.readTree(str);
    }

    private Map<String, Boolean> handleResponse(HttpResponse httpResponse, JsonConverter jsonConverter) throws IOException {
        int status = httpResponse.getStatusLine().getStatusCode();
        if (status == 200) {
            LOG.info("Expected HttpResponse statusCode: {}", (Object)200);
            return jsonConverter.convert(this.getJsonObject(httpResponse));
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        throw new ClientProtocolException("Unexpected response status: " + status + ", reason: " + httpResponse.getStatusLine().getReasonPhrase());
    }

    @VisibleForTesting
    protected HttpResponse post(String url, Map<String, Object> payloads) throws IOException {
        HttpPost postRequest = new HttpPost(url);
        try {
            postRequest.setHeader("Accept", ACCEPT_CONTENT_TYPE);
            StringEntity entity = new StringEntity(OBJECT_MAPPER.writeValueAsString(payloads), ContentType.APPLICATION_JSON);
            postRequest.setEntity((HttpEntity)entity);
            LOG.info("Executing request: {}, headers: {}, entity: {}", new Object[]{postRequest.getRequestLine(), postRequest.getAllHeaders(), postRequest.getEntity()});
            HttpResponse response = this._httpClient.execute((HttpUriRequest)postRequest);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                LOG.warn("Received non-200 status code: {}, payloads: {}", (Object)status, payloads);
            }
            return response;
        }
        catch (IOException e) {
            LOG.error("Failed to perform customized health check. Is participant endpoint {} available?", (Object)url, (Object)e);
            postRequest.releaseConnection();
            throw e;
        }
    }

    private static interface JsonConverter {
        public Map<String, Boolean> convert(JsonNode var1);
    }
}

