/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk.zookeeper;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.apache.helix.manager.zk.zookeeper.ZkClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkEventThread
extends Thread {
    private static Logger LOG = LoggerFactory.getLogger(ZkClient.class);
    private BlockingQueue<ZkEvent> _events = new LinkedBlockingQueue<ZkEvent>();
    private long _totalEventCount = 0L;
    private long _totalEventCountHandled = 0L;
    private static AtomicInteger _eventId = new AtomicInteger(0);

    ZkEventThread(String name) {
        this.setDaemon(true);
        this.setName("ZkClient-EventThread-" + this.getId() + "-" + name);
    }

    @Override
    public void run() {
        LOG.info("Starting ZkClient event thread.");
        try {
            while (!this.isInterrupted()) {
                ZkEvent zkEvent = this._events.take();
                int eventId = _eventId.incrementAndGet();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Delivering event #" + eventId + " " + zkEvent);
                }
                try {
                    zkEvent.run();
                    ++this._totalEventCountHandled;
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                catch (ZkInterruptedException e) {
                    this.interrupt();
                }
                catch (Throwable e) {
                    LOG.error("Error handling event " + zkEvent, e);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Delivering event #" + eventId + " done");
            }
        }
        catch (InterruptedException e) {
            LOG.info("Terminate ZkClient event thread.");
        }
        LOG.info("Terminate ZkClient event thread.");
    }

    public void send(ZkEvent event) {
        if (!this.isInterrupted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("New event: " + event);
            }
            this._events.add(event);
            ++this._totalEventCount;
        }
    }

    public long getPendingEventsCount() {
        return this._events.size();
    }

    public long getTotalEventCount() {
        return this._totalEventCount;
    }

    public long getTotalHandledEventCount() {
        return this._totalEventCountHandled;
    }

    public static abstract class ZkEvent {
        private String _description;

        public ZkEvent(String description) {
            this._description = description;
        }

        public abstract void run() throws Exception;

        public String toString() {
            return "ZkEvent[" + this._description + "]";
        }
    }
}

