/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.I0Itec.zkclient.DataUpdater;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.exception.ZkBadVersionException;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.api.exceptions.HelixMetaDataAccessException;
import org.apache.helix.manager.zk.ZkAsyncCallbacks;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.store.zk.ZNode;
import org.apache.helix.util.HelixUtil;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.DataTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkBaseDataAccessor<T>
implements BaseDataAccessor<T> {
    private static Logger LOG = LoggerFactory.getLogger(ZkBaseDataAccessor.class);
    private final HelixZkClient _zkClient;

    public ZkBaseDataAccessor(HelixZkClient zkClient) {
        if (zkClient == null) {
            throw new NullPointerException("zkclient is null");
        }
        this._zkClient = zkClient;
    }

    @Override
    public boolean create(String path, T record, int options) {
        AccessResult result = this.doCreate(path, record, options);
        return result._retCode == RetCode.OK;
    }

    public AccessResult doCreate(String path, T record, int options) {
        boolean retry;
        AccessResult result = new AccessResult();
        CreateMode mode = AccessOption.getMode(options);
        if (mode == null) {
            LOG.error("Invalid create mode. options: " + options);
            result._retCode = RetCode.ERROR;
            return result;
        }
        do {
            retry = false;
            try {
                this._zkClient.create(path, record, mode);
                result._pathCreated.add(path);
                result._retCode = RetCode.OK;
                return result;
            }
            catch (ZkNoNodeException e) {
                String parentPath = HelixUtil.getZkParentPath(path);
                try {
                    AccessResult res = this.doCreate(parentPath, null, AccessOption.PERSISTENT);
                    result._pathCreated.addAll(res._pathCreated);
                    RetCode rc = res._retCode;
                    if (rc != RetCode.OK && rc != RetCode.NODE_EXISTS) continue;
                    retry = true;
                }
                catch (Exception e1) {
                    LOG.error("Exception while creating path: " + parentPath, (Throwable)e1);
                    result._retCode = RetCode.ERROR;
                    return result;
                }
            }
            catch (ZkNodeExistsException e) {
                LOG.warn("Node already exists. path: " + path);
                result._retCode = RetCode.NODE_EXISTS;
                return result;
            }
            catch (Exception e) {
                LOG.error("Exception while creating path: " + path, (Throwable)e);
                result._retCode = RetCode.ERROR;
                return result;
            }
        } while (retry);
        result._retCode = RetCode.OK;
        return result;
    }

    @Override
    public boolean set(String path, T record, int options) {
        return this.set(path, record, -1, options);
    }

    @Override
    public boolean set(String path, T record, int expectVersion, int options) {
        AccessResult result = this.doSet(path, record, expectVersion, options);
        return result._retCode == RetCode.OK;
    }

    public AccessResult doSet(String path, T record, int expectVersion, int options) {
        boolean retry;
        AccessResult result = new AccessResult();
        CreateMode mode = AccessOption.getMode(options);
        if (mode == null) {
            LOG.error("Invalid set mode. options: " + options);
            result._retCode = RetCode.ERROR;
            return result;
        }
        do {
            retry = false;
            try {
                Stat stat = this._zkClient.writeDataGetStat(path, record, expectVersion);
                DataTree.copyStat((Stat)stat, (Stat)result._stat);
            }
            catch (ZkNoNodeException e) {
                if (expectVersion != -1) {
                    LOG.error("Could not create node if expectVersion != -1, was " + expectVersion);
                    result._retCode = RetCode.ERROR;
                    return result;
                }
                try {
                    AccessResult res = this.doCreate(path, record, options);
                    result._pathCreated.addAll(res._pathCreated);
                    RetCode rc = res._retCode;
                    switch (rc) {
                        case OK: {
                            break;
                        }
                        case NODE_EXISTS: {
                            retry = true;
                            break;
                        }
                        default: {
                            LOG.error("Fail to set path by creating: " + path);
                            result._retCode = RetCode.ERROR;
                            return result;
                        }
                    }
                }
                catch (Exception e1) {
                    LOG.error("Exception while setting path by creating: " + path, (Throwable)e);
                    result._retCode = RetCode.ERROR;
                    return result;
                }
            }
            catch (ZkBadVersionException e) {
                LOG.debug("Exception while setting path: " + path, (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LOG.error("Exception while setting path: " + path, (Throwable)e);
                result._retCode = RetCode.ERROR;
                return result;
            }
        } while (retry);
        result._retCode = RetCode.OK;
        return result;
    }

    @Override
    public boolean update(String path, DataUpdater<T> updater, int options) {
        AccessResult result = this.doUpdate(path, updater, options);
        return result._retCode == RetCode.OK;
    }

    public AccessResult doUpdate(String path, DataUpdater<T> updater, int options) {
        boolean retry;
        AccessResult result = new AccessResult();
        CreateMode mode = AccessOption.getMode(options);
        if (mode == null) {
            LOG.error("Invalid update mode. options: " + options);
            result._retCode = RetCode.ERROR;
            return result;
        }
        Object updatedData = null;
        do {
            retry = false;
            try {
                Stat readStat = new Stat();
                Object oldData = this._zkClient.readData(path, readStat);
                Object newData = updater.update(oldData);
                if (newData != null) {
                    Stat setStat = this._zkClient.writeDataGetStat(path, newData, readStat.getVersion());
                    DataTree.copyStat((Stat)setStat, (Stat)result._stat);
                }
                updatedData = newData;
            }
            catch (ZkBadVersionException e) {
                retry = true;
            }
            catch (ZkNoNodeException e) {
                try {
                    RetCode rc;
                    Object newData = updater.update(null);
                    if (newData != null) {
                        AccessResult res = this.doCreate(path, newData, options);
                        result._pathCreated.addAll(res._pathCreated);
                        rc = res._retCode;
                    } else {
                        rc = RetCode.OK;
                    }
                    switch (rc) {
                        case OK: {
                            updatedData = newData;
                            break;
                        }
                        case NODE_EXISTS: {
                            retry = true;
                            break;
                        }
                        default: {
                            LOG.error("Fail to update path by creating: " + path);
                            result._retCode = RetCode.ERROR;
                            return result;
                        }
                    }
                }
                catch (Exception e1) {
                    LOG.error("Exception while updating path by creating: " + path, (Throwable)e1);
                    result._retCode = RetCode.ERROR;
                    return result;
                }
            }
            catch (Exception e) {
                LOG.error("Exception while updating path: " + path, (Throwable)e);
                result._retCode = RetCode.ERROR;
                return result;
            }
        } while (retry);
        result._retCode = RetCode.OK;
        result._updatedValue = updatedData;
        return result;
    }

    @Override
    public T get(String path, Stat stat, int options) {
        T data;
        block2: {
            data = null;
            try {
                data = this._zkClient.readData(path, stat);
            }
            catch (ZkNoNodeException e) {
                if (!AccessOption.isThrowExceptionIfNotExist(options)) break block2;
                throw e;
            }
        }
        return data;
    }

    @Override
    @Deprecated
    public List<T> get(List<String> paths, List<Stat> stats, int options) {
        boolean[] needRead = new boolean[paths.size()];
        Arrays.fill(needRead, true);
        return this.get(paths, stats, needRead, false);
    }

    @Override
    public List<T> get(List<String> paths, List<Stat> stats, int options, boolean throwException) throws HelixException {
        boolean[] needRead = new boolean[paths.size()];
        Arrays.fill(needRead, true);
        return this.get(paths, stats, needRead, throwException);
    }

    List<T> get(List<String> paths, List<Stat> stats, boolean[] needRead, boolean throwException) throws HelixException {
        if (paths == null || paths.size() == 0) {
            return Collections.emptyList();
        }
        if (stats != null) {
            stats.clear();
            stats.addAll(Collections.nCopies(paths.size(), null));
        }
        long startT = System.nanoTime();
        try {
            int i;
            ZkAsyncCallbacks.GetDataCallbackHandler[] cbList = new ZkAsyncCallbacks.GetDataCallbackHandler[paths.size()];
            for (i = 0; i < paths.size(); ++i) {
                if (!needRead[i]) continue;
                String path = paths.get(i);
                cbList[i] = new ZkAsyncCallbacks.GetDataCallbackHandler();
                this._zkClient.asyncGetData(path, cbList[i]);
            }
            for (i = 0; i < cbList.length; ++i) {
                if (!needRead[i]) continue;
                ZkAsyncCallbacks.GetDataCallbackHandler cb = cbList[i];
                cb.waitForSuccess();
            }
            ArrayList<Object> records = new ArrayList<Object>(Collections.nCopies(paths.size(), null));
            HashMap<String, Integer> pathFailToRead = new HashMap<String, Integer>();
            for (int i2 = 0; i2 < paths.size(); ++i2) {
                if (!needRead[i2]) continue;
                ZkAsyncCallbacks.GetDataCallbackHandler cb = cbList[i2];
                if (KeeperException.Code.get((int)cb.getRc()) == KeeperException.Code.OK) {
                    Object record = this._zkClient.deserialize(cb._data, paths.get(i2));
                    records.set(i2, record);
                    if (stats == null) continue;
                    stats.set(i2, cb._stat);
                    continue;
                }
                if (KeeperException.Code.get((int)cb.getRc()) != KeeperException.Code.NONODE && throwException) {
                    throw new HelixMetaDataAccessException(String.format("Failed to read node %s", paths.get(i2)));
                }
                pathFailToRead.put(paths.get(i2), cb.getRc());
            }
            if (pathFailToRead.size() > 0) {
                LOG.warn("Fail to read record for paths: " + pathFailToRead);
            }
            ArrayList<Object> arrayList = records;
            return arrayList;
        }
        catch (Exception e) {
            throw new HelixMetaDataAccessException(String.format("Fail to read nodes for %s", paths));
        }
        finally {
            long endT = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace("getData_async, size: " + paths.size() + ", paths: " + paths.get(0) + ",... time: " + (endT - startT) + " ns");
            }
        }
    }

    @Override
    @Deprecated
    public List<T> getChildren(String parentPath, List<Stat> stats, int options) {
        return this.getChildren(parentPath, stats, options, false);
    }

    @Override
    public List<T> getChildren(String parentPath, List<Stat> stats, int options, int retryCount, int retryInterval) throws HelixException {
        int readCount = retryCount + 1;
        while (readCount > 0) {
            try {
                --readCount;
                List<T> records = this.getChildren(parentPath, stats, options, true);
                return records;
            }
            catch (HelixMetaDataAccessException e) {
                if (readCount == 0) {
                    throw new HelixMetaDataAccessException(String.format("Failed to get full list of %s", parentPath), e);
                }
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    throw new HelixMetaDataAccessException("Fail to interrupt the sleep", interruptedException);
                }
            }
        }
        return null;
    }

    private List<T> getChildren(String parentPath, List<Stat> stats, int options, boolean throwException) {
        try {
            List<String> childNames = this.getChildNames(parentPath, options);
            if (childNames == null || childNames.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> paths = new ArrayList<String>();
            for (String childName : childNames) {
                String path = parentPath + "/" + childName;
                paths.add(path);
            }
            ArrayList<Stat> curStats = new ArrayList<Stat>(paths.size());
            boolean[] needRead = new boolean[paths.size()];
            Arrays.fill(needRead, true);
            List<T> records = this.get(paths, curStats, needRead, throwException);
            Iterator<T> recordIter = records.iterator();
            Iterator statIter = curStats.iterator();
            while (statIter.hasNext()) {
                recordIter.next();
                if (statIter.next() != null) continue;
                statIter.remove();
                recordIter.remove();
            }
            if (stats != null) {
                stats.clear();
                stats.addAll(curStats);
            }
            return records;
        }
        catch (ZkNoNodeException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public List<String> getChildNames(String parentPath, int options) {
        try {
            List<String> childNames = this._zkClient.getChildren(parentPath);
            Collections.sort(childNames);
            return childNames;
        }
        catch (ZkNoNodeException e) {
            return null;
        }
    }

    @Override
    public boolean exists(String path, int options) {
        return this._zkClient.exists(path);
    }

    @Override
    public Stat getStat(String path, int options) {
        return this._zkClient.getStat(path);
    }

    @Override
    public boolean remove(String path, int options) {
        try {
            this._zkClient.delete(path);
        }
        catch (ZkException e) {
            LOG.debug("Failed to delete {} with opts {}, err: {}. Try recursive delete", new Object[]{path, options, e.getMessage()});
            try {
                this._zkClient.deleteRecursively(path);
            }
            catch (HelixException he) {
                LOG.error("Failed to delete {} recursively with opts {}.", new Object[]{path, options, he});
                return false;
            }
        }
        return true;
    }

    ZkAsyncCallbacks.CreateCallbackHandler[] create(List<String> paths, List<T> records, boolean[] needCreate, List<List<String>> pathsCreated, int options) {
        boolean retry;
        if (records != null && records.size() != paths.size() || needCreate.length != paths.size() || pathsCreated != null && pathsCreated.size() != paths.size()) {
            throw new IllegalArgumentException("paths, records, needCreate, and pathsCreated should be of same size");
        }
        ZkAsyncCallbacks.CreateCallbackHandler[] cbList = new ZkAsyncCallbacks.CreateCallbackHandler[paths.size()];
        CreateMode mode = AccessOption.getMode(options);
        if (mode == null) {
            LOG.error("Invalid async set mode. options: " + options);
            return cbList;
        }
        block0: do {
            retry = false;
            for (int i = 0; i < paths.size(); ++i) {
                if (!needCreate[i]) continue;
                String path = paths.get(i);
                Object record = records == null ? null : records.get(i);
                cbList[i] = new ZkAsyncCallbacks.CreateCallbackHandler();
                this._zkClient.asyncCreate(path, record, mode, cbList[i]);
            }
            ArrayList<Object> parentPaths = new ArrayList<Object>(Collections.nCopies(paths.size(), null));
            boolean failOnNoNode = false;
            for (int i = 0; i < paths.size(); ++i) {
                if (!needCreate[i]) continue;
                ZkAsyncCallbacks.CreateCallbackHandler cb = cbList[i];
                cb.waitForSuccess();
                String path = paths.get(i);
                if (KeeperException.Code.get((int)cb.getRc()) == KeeperException.Code.NONODE) {
                    String parentPath = HelixUtil.getZkParentPath(path);
                    parentPaths.set(i, parentPath);
                    failOnNoNode = true;
                    continue;
                }
                needCreate[i] = false;
                if (KeeperException.Code.get((int)cb.getRc()) != KeeperException.Code.OK || pathsCreated == null) continue;
                if (pathsCreated.get(i) == null) {
                    pathsCreated.set(i, new ArrayList());
                }
                pathsCreated.get(i).add(path);
            }
            if (!failOnNoNode) continue;
            boolean[] needCreateParent = Arrays.copyOf(needCreate, needCreate.length);
            ZkAsyncCallbacks.CreateCallbackHandler[] parentCbList = this.create(parentPaths, null, needCreateParent, pathsCreated, AccessOption.PERSISTENT);
            for (int i = 0; i < parentCbList.length; ++i) {
                KeeperException.Code rc;
                ZkAsyncCallbacks.CreateCallbackHandler parentCb = parentCbList[i];
                if (parentCb == null || (rc = KeeperException.Code.get((int)parentCb.getRc())) != KeeperException.Code.OK && rc != KeeperException.Code.NODEEXISTS) continue;
                retry = true;
                continue block0;
            }
        } while (retry);
        return cbList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] createChildren(List<String> paths, List<T> records, int options) {
        boolean[] success = new boolean[paths.size()];
        CreateMode mode = AccessOption.getMode(options);
        if (mode == null) {
            LOG.error("Invalid async create mode. options: " + options);
            return success;
        }
        boolean[] needCreate = new boolean[paths.size()];
        Arrays.fill(needCreate, true);
        ArrayList<Object> pathsCreated = new ArrayList<Object>(Collections.nCopies(paths.size(), null));
        long startT = System.nanoTime();
        try {
            ZkAsyncCallbacks.CreateCallbackHandler[] cbList = this.create(paths, records, needCreate, pathsCreated, options);
            for (int i = 0; i < cbList.length; ++i) {
                ZkAsyncCallbacks.CreateCallbackHandler cb = cbList[i];
                success[i] = KeeperException.Code.get((int)cb.getRc()) == KeeperException.Code.OK;
            }
            boolean[] blArray = success;
            return blArray;
        }
        finally {
            long endT = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace("create_async, size: " + paths.size() + ", paths: " + paths.get(0) + ",... time: " + (endT - startT) + " ns");
            }
        }
    }

    @Override
    public boolean[] setChildren(List<String> paths, List<T> records, int options) {
        return this.set(paths, records, null, null, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean[] set(List<String> paths, List<T> records, List<List<String>> pathsCreated, List<Stat> stats, int options) {
        if (paths == null || paths.size() == 0) {
            return new boolean[0];
        }
        if (records != null && records.size() != paths.size() || pathsCreated != null && pathsCreated.size() != paths.size()) {
            throw new IllegalArgumentException("paths, records, and pathsCreated should be of same size");
        }
        boolean[] success = new boolean[paths.size()];
        CreateMode mode = AccessOption.getMode(options);
        if (mode == null) {
            LOG.error("Invalid async set mode. options: " + options);
            return success;
        }
        ArrayList<Object> setStats = new ArrayList<Object>(Collections.nCopies(paths.size(), null));
        ZkAsyncCallbacks.SetDataCallbackHandler[] cbList = new ZkAsyncCallbacks.SetDataCallbackHandler[paths.size()];
        ZkAsyncCallbacks.CreateCallbackHandler[] createCbList = null;
        boolean[] needSet = new boolean[paths.size()];
        Arrays.fill(needSet, true);
        long startT = System.nanoTime();
        try {
            ZkAsyncCallbacks.CreateCallbackHandler createCb;
            int i;
            boolean retry;
            do {
                retry = false;
                for (i = 0; i < paths.size(); ++i) {
                    if (!needSet[i]) continue;
                    String path = paths.get(i);
                    T record = records.get(i);
                    cbList[i] = new ZkAsyncCallbacks.SetDataCallbackHandler();
                    this._zkClient.asyncSetData(path, record, -1, cbList[i]);
                }
                boolean failOnNoNode = false;
                block13: for (int i2 = 0; i2 < cbList.length; ++i2) {
                    ZkAsyncCallbacks.SetDataCallbackHandler cb = cbList[i2];
                    cb.waitForSuccess();
                    KeeperException.Code rc = KeeperException.Code.get((int)cb.getRc());
                    switch (rc) {
                        case OK: {
                            setStats.set(i2, cb.getStat());
                            needSet[i2] = false;
                            continue block13;
                        }
                        case NONODE: {
                            failOnNoNode = true;
                            continue block13;
                        }
                        default: {
                            needSet[i2] = false;
                        }
                    }
                }
                if (!failOnNoNode) continue;
                boolean[] needCreate = Arrays.copyOf(needSet, needSet.length);
                createCbList = this.create(paths, records, needCreate, pathsCreated, options);
                block14: for (int i3 = 0; i3 < createCbList.length; ++i3) {
                    createCb = createCbList[i3];
                    if (createCb == null) continue;
                    KeeperException.Code rc = KeeperException.Code.get((int)createCb.getRc());
                    switch (rc) {
                        case OK: {
                            setStats.set(i3, ZNode.ZERO_STAT);
                            needSet[i3] = false;
                            continue block14;
                        }
                        case NODEEXISTS: {
                            retry = true;
                            continue block14;
                        }
                        default: {
                            needSet[i3] = false;
                        }
                    }
                }
            } while (retry);
            for (i = 0; i < cbList.length; ++i) {
                ZkAsyncCallbacks.SetDataCallbackHandler cb = cbList[i];
                KeeperException.Code rc = KeeperException.Code.get((int)cb.getRc());
                if (rc == KeeperException.Code.OK) {
                    success[i] = true;
                    continue;
                }
                if (rc != KeeperException.Code.NONODE || KeeperException.Code.get((int)(createCb = createCbList[i]).getRc()) != KeeperException.Code.OK) continue;
                success[i] = true;
            }
            if (stats != null) {
                stats.clear();
                stats.addAll(setStats);
            }
            boolean[] blArray = success;
            return blArray;
        }
        finally {
            long endT = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace("setData_async, size: " + paths.size() + ", paths: " + paths.get(0) + ",... time: " + (endT - startT) + " ns");
            }
        }
    }

    @Override
    public boolean[] updateChildren(List<String> paths, List<DataUpdater<T>> updaters, int options) {
        List<T> updateData = this.update(paths, updaters, null, null, options);
        boolean[] success = new boolean[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            T data = updateData.get(i);
            success[i] = data != null;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<T> update(List<String> paths, List<DataUpdater<T>> updaters, List<List<String>> pathsCreated, List<Stat> stats, int options) {
        if (paths == null || paths.size() == 0) {
            LOG.error("paths is null or empty");
            return Collections.emptyList();
        }
        if (updaters.size() != paths.size() || pathsCreated != null && pathsCreated.size() != paths.size()) {
            throw new IllegalArgumentException("paths, updaters, and pathsCreated should be of same size");
        }
        ArrayList<Object> setStats = new ArrayList<Object>(Collections.nCopies(paths.size(), null));
        ArrayList<Object> updateData = new ArrayList<Object>(Collections.nCopies(paths.size(), null));
        CreateMode mode = AccessOption.getMode(options);
        if (mode == null) {
            LOG.error("Invalid update mode. options: " + options);
            return updateData;
        }
        ZkAsyncCallbacks.SetDataCallbackHandler[] cbList = new ZkAsyncCallbacks.SetDataCallbackHandler[paths.size()];
        ZkAsyncCallbacks.CreateCallbackHandler[] createCbList = null;
        boolean[] needUpdate = new boolean[paths.size()];
        Arrays.fill(needUpdate, true);
        long startT = System.nanoTime();
        try {
            boolean retry;
            do {
                int i;
                retry = false;
                boolean[] needCreate = new boolean[paths.size()];
                boolean failOnNoNode = false;
                ArrayList<Stat> curStats = new ArrayList<Stat>();
                List<T> curDataList = this.get(paths, curStats, Arrays.copyOf(needUpdate, needUpdate.length), false);
                ArrayList<Object> newDataList = new ArrayList<Object>();
                for (int i2 = 0; i2 < paths.size(); ++i2) {
                    if (!needUpdate[i2]) {
                        newDataList.add(null);
                        continue;
                    }
                    String path = paths.get(i2);
                    DataUpdater<T> updater = updaters.get(i2);
                    Object newData = updater.update(curDataList.get(i2));
                    newDataList.add(newData);
                    if (newData == null) continue;
                    Stat curStat = (Stat)curStats.get(i2);
                    if (curStat == null) {
                        failOnNoNode = true;
                        needCreate[i2] = true;
                        continue;
                    }
                    cbList[i2] = new ZkAsyncCallbacks.SetDataCallbackHandler();
                    this._zkClient.asyncSetData(path, newData, curStat.getVersion(), cbList[i2]);
                }
                boolean failOnBadVersion = false;
                block14: for (i = 0; i < paths.size(); ++i) {
                    ZkAsyncCallbacks.SetDataCallbackHandler cb = cbList[i];
                    if (cb == null) continue;
                    cb.waitForSuccess();
                    switch (KeeperException.Code.get((int)cb.getRc())) {
                        case OK: {
                            updateData.set(i, newDataList.get(i));
                            setStats.set(i, cb.getStat());
                            needUpdate[i] = false;
                            continue block14;
                        }
                        case NONODE: {
                            failOnNoNode = true;
                            needCreate[i] = true;
                            continue block14;
                        }
                        case BADVERSION: {
                            failOnBadVersion = true;
                            continue block14;
                        }
                        default: {
                            needUpdate[i] = false;
                        }
                    }
                }
                if (failOnNoNode) {
                    createCbList = this.create(paths, newDataList, needCreate, pathsCreated, options);
                    block15: for (i = 0; i < paths.size(); ++i) {
                        ZkAsyncCallbacks.CreateCallbackHandler createCb = createCbList[i];
                        if (createCb == null) continue;
                        switch (KeeperException.Code.get((int)createCb.getRc())) {
                            case OK: {
                                needUpdate[i] = false;
                                updateData.set(i, newDataList.get(i));
                                setStats.set(i, ZNode.ZERO_STAT);
                                continue block15;
                            }
                            case NODEEXISTS: {
                                retry = true;
                                continue block15;
                            }
                            default: {
                                needUpdate[i] = false;
                            }
                        }
                    }
                }
                if (!failOnBadVersion) continue;
                retry = true;
            } while (retry);
            if (stats != null) {
                stats.clear();
                stats.addAll(setStats);
            }
            ArrayList<Object> arrayList = updateData;
            return arrayList;
        }
        finally {
            long endT = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace("setData_async, size: " + paths.size() + ", paths: " + paths.get(0) + ",... time: " + (endT - startT) + " ns");
            }
        }
    }

    @Override
    public boolean[] exists(List<String> paths, int options) {
        Stat[] stats = this.getStats(paths, options);
        boolean[] exists = new boolean[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            exists[i] = stats[i] != null;
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stat[] getStats(List<String> paths, int options) {
        if (paths == null || paths.size() == 0) {
            LOG.error("paths is null or empty");
            return new Stat[0];
        }
        Stat[] stats = new Stat[paths.size()];
        long startT = System.nanoTime();
        try {
            int i;
            ZkAsyncCallbacks.ExistsCallbackHandler[] cbList = new ZkAsyncCallbacks.ExistsCallbackHandler[paths.size()];
            for (i = 0; i < paths.size(); ++i) {
                String path = paths.get(i);
                cbList[i] = new ZkAsyncCallbacks.ExistsCallbackHandler();
                this._zkClient.asyncExists(path, cbList[i]);
            }
            for (i = 0; i < cbList.length; ++i) {
                ZkAsyncCallbacks.ExistsCallbackHandler cb = cbList[i];
                cb.waitForSuccess();
                stats[i] = cb._stat;
            }
            Stat[] statArray = stats;
            return statArray;
        }
        finally {
            long endT = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace("exists_async, size: " + paths.size() + ", paths: " + paths.get(0) + ",... time: " + (endT - startT) + " ns");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] remove(List<String> paths, int options) {
        if (paths == null || paths.size() == 0) {
            return new boolean[0];
        }
        boolean[] success = new boolean[paths.size()];
        ZkAsyncCallbacks.DeleteCallbackHandler[] cbList = new ZkAsyncCallbacks.DeleteCallbackHandler[paths.size()];
        long startT = System.nanoTime();
        try {
            int i;
            for (i = 0; i < paths.size(); ++i) {
                String path = paths.get(i);
                cbList[i] = new ZkAsyncCallbacks.DeleteCallbackHandler();
                this._zkClient.asyncDelete(path, cbList[i]);
            }
            for (i = 0; i < cbList.length; ++i) {
                ZkAsyncCallbacks.DeleteCallbackHandler cb = cbList[i];
                cb.waitForSuccess();
                success[i] = cb.getRc() == 0;
            }
            boolean[] blArray = success;
            return blArray;
        }
        finally {
            long endT = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace("delete_async, size: " + paths.size() + ", paths: " + paths.get(0) + ",... time: " + (endT - startT) + " ns");
            }
        }
    }

    @Override
    public void subscribeDataChanges(String path, IZkDataListener listener) {
        this._zkClient.subscribeDataChanges(path, listener);
    }

    @Override
    public void unsubscribeDataChanges(String path, IZkDataListener dataListener) {
        this._zkClient.unsubscribeDataChanges(path, dataListener);
    }

    @Override
    public List<String> subscribeChildChanges(String path, IZkChildListener listener) {
        return this._zkClient.subscribeChildChanges(path, listener);
    }

    @Override
    public void unsubscribeChildChanges(String path, IZkChildListener childListener) {
        this._zkClient.unsubscribeChildChanges(path, childListener);
    }

    @Override
    public void reset() {
    }

    public class AccessResult {
        RetCode _retCode = RetCode.ERROR;
        List<String> _pathCreated = new ArrayList<String>();
        Stat _stat = new Stat();
        T _updatedValue = null;
    }

    static enum RetCode {
        OK,
        NODE_EXISTS,
        ERROR;

    }
}

