/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.service;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.helix.rest.server.json.instance.InstanceInfo;
import org.apache.helix.rest.server.json.instance.StoppableCheck;

public interface InstanceService {
    public InstanceInfo getInstanceInfo(String var1, String var2, List<HealthCheck> var3);

    public StoppableCheck getInstanceStoppableCheck(String var1, String var2, String var3) throws IOException;

    public Map<String, StoppableCheck> batchGetInstancesStoppableChecks(String var1, List<String> var2, String var3) throws IOException;

    public static enum HealthCheck {
        INSTANCE_NOT_ALIVE,
        INSTANCE_NOT_ENABLED,
        INSTANCE_NOT_STABLE,
        EMPTY_RESOURCE_ASSIGNMENT,
        HAS_DISABLED_PARTITION,
        INVALID_CONFIG,
        HAS_ERROR_PARTITION,
        MIN_ACTIVE_REPLICA_CHECK_FAILED;

        public static List<HealthCheck> STOPPABLE_CHECK_LIST;
        public static List<HealthCheck> STARTED_AND_HEALTH_CHECK_LIST;

        static {
            STOPPABLE_CHECK_LIST = Arrays.asList(HealthCheck.values());
            STARTED_AND_HEALTH_CHECK_LIST = ImmutableList.of((Object)((Object)INSTANCE_NOT_ALIVE), (Object)((Object)INSTANCE_NOT_ENABLED), (Object)((Object)INSTANCE_NOT_STABLE), (Object)((Object)EMPTY_RESOURCE_ASSIGNMENT));
        }
    }
}

