/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplicationStorageFactoryHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationStorageFactoryHelper.class);

    private ReplicationStorageFactoryHelper() {
    }

    public static ReplicationPeerStorage getReplicationPeerStorage(Configuration conf, ZKWatcher zkw, FileSystem fs) {
        try {
            Method method = ReplicationStorageFactory.class.getMethod("getReplicationPeerStorage", FileSystem.class, ZKWatcher.class, Configuration.class);
            return (ReplicationPeerStorage)method.invoke(null, fs, zkw, conf);
        }
        catch (NoSuchMethodException e) {
            LOG.debug("No getReplicationPeerStorage method with FileSystem as a parameter, should be HBase 2.6-", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        try {
            Method method = ReplicationStorageFactory.class.getMethod("getReplicationPeerStorage", ZKWatcher.class, Configuration.class);
            return (ReplicationPeerStorage)method.invoke(null, zkw, conf);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static ReplicationQueueStorage getReplicationQueueStorage(Configuration conf, ZKWatcher zkw, Connection conn) {
        try {
            Method method = ReplicationStorageFactory.class.getMethod("getReplicationQueueStorage", Connection.class, Configuration.class);
            return (ReplicationQueueStorage)method.invoke(null, conn, conf);
        }
        catch (NoSuchMethodException e) {
            LOG.debug("No getReplicationQueueStorage method with Connection as a parameter, should be HBase 2.x", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        try {
            Method method = ReplicationStorageFactory.class.getMethod("getReplicationQueueStorage", ZKWatcher.class, Configuration.class);
            return (ReplicationQueueStorage)method.invoke(null, zkw, conf);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

