/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.vault.ksm.conf;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.keepersecurity.secretsManager.core.InMemoryStorage;
import com.keepersecurity.secretsManager.core.KeyValueStorage;
import com.keepersecurity.secretsManager.core.SecretsManagerOptions;
import javax.annotation.Nonnull;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.properties.BooleanGuacamoleProperty;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.properties.LongGuacamoleProperty;
import org.apache.guacamole.properties.StringGuacamoleProperty;
import org.apache.guacamole.vault.conf.VaultConfigurationService;

@Singleton
public class KsmConfigurationService
extends VaultConfigurationService {
    @Inject
    private Environment environment;
    private static final String TOKEN_MAPPING_FILENAME = "ksm-token-mapping.yml";
    private static final String PROPERTIES_FILENAME = "guacamole.properties.ksm";
    private static final StringGuacamoleProperty KSM_CONFIG = new StringGuacamoleProperty(){

        public String getName() {
            return "ksm-config";
        }
    };
    private static final BooleanGuacamoleProperty ALLOW_UNVERIFIED_CERT = new BooleanGuacamoleProperty(){

        public String getName() {
            return "ksm-allow-unverified-cert";
        }
    };
    private static final BooleanGuacamoleProperty ALLOW_USER_CONFIG = new BooleanGuacamoleProperty(){

        public String getName() {
            return "ksm-allow-user-config";
        }
    };
    private static final BooleanGuacamoleProperty STRIP_WINDOWS_DOMAINS = new BooleanGuacamoleProperty(){

        public String getName() {
            return "ksm-strip-windows-domains";
        }
    };
    private static final BooleanGuacamoleProperty MATCH_USER_DOMAINS = new BooleanGuacamoleProperty(){

        public String getName() {
            return "ksm-match-domains-for-users";
        }
    };
    private static final LongGuacamoleProperty KSM_API_CALL_INTERVAL = new LongGuacamoleProperty(){

        public String getName() {
            return "ksm-api-call-interval";
        }
    };

    public KsmConfigurationService() {
        super(TOKEN_MAPPING_FILENAME, PROPERTIES_FILENAME);
    }

    public boolean getAllowUnverifiedCertificate() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)ALLOW_UNVERIFIED_CERT, (Object)false);
    }

    public boolean getAllowUserConfig() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)ALLOW_USER_CONFIG, (Object)false);
    }

    public boolean getSplitWindowsUsernames() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)STRIP_WINDOWS_DOMAINS, (Object)false);
    }

    public boolean getMatchUserRecordsByDomain() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)MATCH_USER_DOMAINS, (Object)false);
    }

    public long getKsmApiInterval() throws GuacamoleException {
        return (Long)this.environment.getProperty((GuacamoleProperty)KSM_API_CALL_INTERVAL, (Object)10000L);
    }

    @Nonnull
    public String getKsmConfig() throws GuacamoleException {
        return (String)this.environment.getRequiredProperty((GuacamoleProperty)KSM_CONFIG);
    }

    private static KeyValueStorage parseKsmConfig(String value) throws GuacamoleException {
        try {
            return new InMemoryStorage(value);
        }
        catch (IllegalArgumentException e) {
            throw new GuacamoleServerException("Invalid base64 configuration for Keeper Secrets Manager.", (Throwable)e);
        }
    }

    @Nonnull
    public SecretsManagerOptions getSecretsManagerOptions(@Nonnull String ksmConfig) throws GuacamoleException {
        return new SecretsManagerOptions(KsmConfigurationService.parseKsmConfig(ksmConfig), null, this.getAllowUnverifiedCertificate());
    }
}

