/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.calendar;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.guacamole.calendar.DailyRestriction;

public class TimeRestrictionParser {
    private static final Pattern RESTRICTION_REGEX = Pattern.compile("(?:^|;)+([0-7*])(?::((?:[01][0-9]|2[0-3])[0-5][0-9])\\-((?:[01][0-9]|2[0-3])[0-5][0-9]))+");
    private static final int RESTRICTION_DAY_GROUP = 1;
    private static final int RESTRICTION_TIME_START_GROUP = 2;
    private static final int RESTRICTION_TIME_END_GROUP = 3;
    private static final List<DayOfWeek> RESTRICTION_ALL_DAYS = Arrays.asList(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);

    public static List<DailyRestriction> parseString(String restrictionString) {
        ArrayList<DailyRestriction> restrictions = new ArrayList<DailyRestriction>();
        Matcher restrictionMatcher = RESTRICTION_REGEX.matcher(restrictionString);
        block6: while (restrictionMatcher.find()) {
            String dayString = restrictionMatcher.group(1);
            String startTimeString = restrictionMatcher.group(2);
            String endTimeString = restrictionMatcher.group(3);
            if (dayString == null || dayString.isEmpty()) continue;
            DateTimeFormatter hourFormat = DateTimeFormatter.ofPattern("HHmm");
            LocalTime startTime = startTimeString == null || startTimeString.isEmpty() ? LocalTime.of(0, 0, 0) : LocalTime.parse(startTimeString, hourFormat);
            LocalTime endTime = endTimeString == null || endTimeString.isEmpty() ? LocalTime.of(23, 59, 59) : LocalTime.parse(endTimeString, hourFormat);
            switch (dayString) {
                case "*": {
                    restrictions.add(new DailyRestriction(RESTRICTION_ALL_DAYS, startTime, endTime));
                    continue block6;
                }
            }
            int dayInt = Integer.parseInt(dayString);
            if (dayInt == 0) {
                dayInt = 7;
            }
            restrictions.add(new DailyRestriction(DayOfWeek.of(dayInt), startTime, endTime));
        }
        return restrictions;
    }
}

