/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap.conf;

import java.util.Collections;
import java.util.List;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.ldap.conf.EncryptionMethod;
import org.apache.guacamole.auth.ldap.conf.LDAPConfiguration;
import org.apache.guacamole.auth.ldap.conf.MemberAttributeType;

public class DefaultLDAPConfiguration
implements LDAPConfiguration {
    @Override
    public String appliesTo(String username) {
        return null;
    }

    @Override
    public String getServerHostname() {
        return "localhost";
    }

    @Override
    public int getServerPort() {
        return this.getEncryptionMethod().DEFAULT_PORT;
    }

    @Override
    public List<String> getUsernameAttributes() {
        return Collections.singletonList("uid");
    }

    @Override
    public Dn getUserBaseDN() throws GuacamoleException {
        throw new GuacamoleServerException("All LDAP servers must have a defined user base DN.");
    }

    @Override
    public Dn getConfigurationBaseDN() {
        return null;
    }

    @Override
    public List<String> getGroupNameAttributes() {
        return Collections.singletonList("cn");
    }

    @Override
    public Dn getGroupBaseDN() {
        return null;
    }

    @Override
    public String getSearchBindDN() {
        return null;
    }

    @Override
    public String getSearchBindPassword() {
        return null;
    }

    @Override
    public EncryptionMethod getEncryptionMethod() {
        return EncryptionMethod.NONE;
    }

    @Override
    public int getMaxResults() {
        return 1000;
    }

    @Override
    public AliasDerefMode getDereferenceAliases() {
        return AliasDerefMode.NEVER_DEREF_ALIASES;
    }

    @Override
    public boolean getFollowReferrals() {
        return false;
    }

    @Override
    public int getMaxReferralHops() {
        return 5;
    }

    @Override
    public ExprNode getUserSearchFilter() {
        return new PresenceNode("objectClass");
    }

    @Override
    public ExprNode getGroupSearchFilter() {
        return new PresenceNode("objectClass");
    }

    @Override
    public int getOperationTimeout() {
        return 30;
    }

    @Override
    public int getNetworkTimeout() {
        return 30000;
    }

    @Override
    public List<String> getAttributes() {
        return Collections.emptyList();
    }

    @Override
    public String getMemberAttribute() {
        return "member";
    }

    @Override
    public MemberAttributeType getMemberAttributeType() throws GuacamoleException {
        return MemberAttributeType.DN;
    }
}

