/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap.conf;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.ldap.conf.DefaultLDAPConfiguration;
import org.apache.guacamole.auth.ldap.conf.EncryptionMethod;
import org.apache.guacamole.auth.ldap.conf.LDAPConfiguration;
import org.apache.guacamole.auth.ldap.conf.LDAPGuacamoleProperties;
import org.apache.guacamole.auth.ldap.conf.MemberAttributeType;
import org.apache.guacamole.properties.GuacamoleProperty;

public class JacksonLDAPConfiguration
implements LDAPConfiguration {
    @JsonProperty(value="match-usernames")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<Pattern> matchUsernames;
    @JsonProperty(value="hostname")
    private String hostname;
    @JsonProperty(value="port")
    private Integer port;
    @JsonProperty(value="username-attribute")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> usernameAttributes;
    @JsonProperty(value="user-base-dn")
    private String userBaseDn;
    @JsonProperty(value="config-base-dn")
    private String configBaseDn;
    @JsonProperty(value="group-base-dn")
    private String groupBaseDn;
    @JsonProperty(value="group-name-attribute")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> groupNameAttributes;
    @JsonProperty(value="search-bind-dn")
    private String searchBindDn;
    @JsonProperty(value="search-bind-password")
    private String searchBindPassword;
    @JsonProperty(value="encryption-method")
    private String encryptionMethod;
    @JsonProperty(value="max-search-results")
    private Integer maxSearchResults;
    @JsonProperty(value="dereference-aliases")
    private String dereferenceAliases;
    @JsonProperty(value="follow-referrals")
    private Boolean followReferrals;
    @JsonProperty(value="max-referral-hops")
    private Integer maxReferralHops;
    @JsonProperty(value="user-search-filter")
    private String userSearchFilter;
    @JsonProperty(value="group-search-filter")
    private String groupSearchFilter;
    @JsonProperty(value="operation-timeout")
    private Integer operationTimeout;
    @JsonProperty(value="network-timeout")
    private Integer networkTimeout;
    @JsonProperty(value="user-attributes")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> userAttributes;
    @JsonProperty(value="member-attribute")
    private String memberAttribute;
    @JsonProperty(value="member-attribute-type")
    private String memberAttributeType;
    private LDAPConfiguration defaultConfig = new DefaultLDAPConfiguration();

    private <T> T withDefault(T value, DefaultSupplier<T> defaultValue) throws GuacamoleException {
        return value != null ? value : defaultValue.get();
    }

    private <T> T withDefault(GuacamoleProperty<T> property, String value, DefaultSupplier<T> defaultValue) throws GuacamoleException {
        return (T)this.withDefault(property.parseValue(value), defaultValue);
    }

    public void setDefaults(LDAPConfiguration defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    @Override
    public String appliesTo(String username) throws GuacamoleException {
        if (this.matchUsernames == null || this.matchUsernames.isEmpty()) {
            return username;
        }
        for (Pattern pattern : this.matchUsernames) {
            Matcher matcher = pattern.matcher(username);
            if (!matcher.matches()) continue;
            return matcher.groupCount() >= 1 ? matcher.group(1) : username;
        }
        return null;
    }

    @Override
    public String getServerHostname() throws GuacamoleException {
        return this.withDefault(this.hostname, this.defaultConfig::getServerHostname);
    }

    @Override
    public int getServerPort() throws GuacamoleException {
        return this.withDefault(this.port, () -> this.getEncryptionMethod().DEFAULT_PORT);
    }

    @Override
    public List<String> getUsernameAttributes() throws GuacamoleException {
        return this.withDefault(this.usernameAttributes, this.defaultConfig::getUsernameAttributes);
    }

    @Override
    public Dn getUserBaseDN() throws GuacamoleException {
        return this.withDefault(LDAPGuacamoleProperties.LDAP_USER_BASE_DN, this.userBaseDn, this.defaultConfig::getUserBaseDN);
    }

    @Override
    public Dn getConfigurationBaseDN() throws GuacamoleException {
        return this.withDefault(LDAPGuacamoleProperties.LDAP_CONFIG_BASE_DN, this.configBaseDn, this.defaultConfig::getConfigurationBaseDN);
    }

    @Override
    public List<String> getGroupNameAttributes() throws GuacamoleException {
        return this.withDefault(this.groupNameAttributes, this.defaultConfig::getGroupNameAttributes);
    }

    @Override
    public Dn getGroupBaseDN() throws GuacamoleException {
        return this.withDefault(LDAPGuacamoleProperties.LDAP_GROUP_BASE_DN, this.groupBaseDn, this.defaultConfig::getGroupBaseDN);
    }

    @Override
    public String getSearchBindDN() throws GuacamoleException {
        return this.withDefault(this.searchBindDn, this.defaultConfig::getSearchBindDN);
    }

    @Override
    public String getSearchBindPassword() throws GuacamoleException {
        return this.withDefault(this.searchBindPassword, this.defaultConfig::getSearchBindPassword);
    }

    @Override
    public EncryptionMethod getEncryptionMethod() throws GuacamoleException {
        return this.withDefault((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_ENCRYPTION_METHOD, this.encryptionMethod, this.defaultConfig::getEncryptionMethod);
    }

    @Override
    public int getMaxResults() throws GuacamoleException {
        return this.withDefault(this.maxSearchResults, this.defaultConfig::getMaxResults);
    }

    @Override
    public AliasDerefMode getDereferenceAliases() throws GuacamoleException {
        return this.withDefault((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_DEREFERENCE_ALIASES, this.dereferenceAliases, this.defaultConfig::getDereferenceAliases);
    }

    @Override
    public boolean getFollowReferrals() throws GuacamoleException {
        return this.withDefault(this.followReferrals, this.defaultConfig::getFollowReferrals);
    }

    @Override
    public int getMaxReferralHops() throws GuacamoleException {
        return this.withDefault(this.maxReferralHops, this.defaultConfig::getMaxReferralHops);
    }

    @Override
    public ExprNode getUserSearchFilter() throws GuacamoleException {
        return this.withDefault(LDAPGuacamoleProperties.LDAP_USER_SEARCH_FILTER, this.userSearchFilter, this.defaultConfig::getUserSearchFilter);
    }

    @Override
    public ExprNode getGroupSearchFilter() throws GuacamoleException {
        return this.withDefault(LDAPGuacamoleProperties.LDAP_GROUP_SEARCH_FILTER, this.groupSearchFilter, this.defaultConfig::getGroupSearchFilter);
    }

    @Override
    public int getOperationTimeout() throws GuacamoleException {
        return this.withDefault(this.operationTimeout, this.defaultConfig::getOperationTimeout);
    }

    @Override
    public int getNetworkTimeout() throws GuacamoleException {
        return this.withDefault(this.networkTimeout, this.defaultConfig::getNetworkTimeout);
    }

    @Override
    public List<String> getAttributes() throws GuacamoleException {
        return this.withDefault(this.userAttributes, this.defaultConfig::getAttributes);
    }

    @Override
    public String getMemberAttribute() throws GuacamoleException {
        return this.withDefault(this.memberAttribute, this.defaultConfig::getMemberAttribute);
    }

    @Override
    public MemberAttributeType getMemberAttributeType() throws GuacamoleException {
        return this.withDefault((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_MEMBER_ATTRIBUTE_TYPE, this.memberAttributeType, this.defaultConfig::getMemberAttributeType);
    }

    @FunctionalInterface
    private static interface DefaultSupplier<T> {
        public T get() throws GuacamoleException;
    }
}

