/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.oss.fs;

import com.aliyun.oss.common.auth.BasicCredentials;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentials;
import java.net.URI;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemUtils;
import org.apache.gravitino.catalog.hadoop.fs.GravitinoFileSystemCredentialsProvider;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.OSSSecretKeyCredential;
import org.apache.gravitino.credential.OSSTokenCredential;
import org.apache.gravitino.oss.fs.OSSUtils;
import org.apache.hadoop.conf.Configuration;

public class OSSCredentialsProvider
implements CredentialsProvider {
    private GravitinoFileSystemCredentialsProvider gravitinoFileSystemCredentialsProvider;
    private Credentials basicCredentials;
    private long expirationTime = Long.MAX_VALUE;
    private static final double EXPIRATION_TIME_FACTOR = 0.5;

    public OSSCredentialsProvider(URI uri, Configuration conf) {
        this.gravitinoFileSystemCredentialsProvider = FileSystemUtils.getGvfsCredentialProvider((Configuration)conf);
    }

    public void setCredentials(Credentials credentials) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credentials getCredentials() {
        if (this.basicCredentials == null || System.currentTimeMillis() >= this.expirationTime) {
            OSSCredentialsProvider oSSCredentialsProvider = this;
            synchronized (oSSCredentialsProvider) {
                this.refresh();
            }
        }
        return this.basicCredentials;
    }

    private void refresh() {
        Credential[] gravitinoCredentials = this.gravitinoFileSystemCredentialsProvider.getCredentials();
        Credential credential = OSSUtils.getSuitableCredential(gravitinoCredentials);
        if (credential == null) {
            throw new RuntimeException("No suitable credential for OSS found...");
        }
        if (credential instanceof OSSSecretKeyCredential) {
            OSSSecretKeyCredential ossSecretKeyCredential = (OSSSecretKeyCredential)credential;
            this.basicCredentials = new DefaultCredentials(ossSecretKeyCredential.accessKeyId(), ossSecretKeyCredential.secretAccessKey());
        } else if (credential instanceof OSSTokenCredential) {
            OSSTokenCredential ossTokenCredential = (OSSTokenCredential)credential;
            this.basicCredentials = new BasicCredentials(ossTokenCredential.accessKeyId(), ossTokenCredential.secretAccessKey(), ossTokenCredential.securityToken());
        }
        if (credential.expireTimeInMs() > 0L) {
            this.expirationTime = System.currentTimeMillis() + (long)((double)(credential.expireTimeInMs() - System.currentTimeMillis()) * 0.5);
        }
    }
}

