/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gravitino.dto.VersionDTO;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class Version {
    public static final String CLIENT_VERSION_HEADER = "X-Client-Version";
    private static final int VERSION_PART_NUMBER = 3;
    private static final Pattern PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(?:-.*|\\.([a-zA-Z].*))?$");
    private static final Version INSTANCE = new Version();
    private final VersionInfo versionInfo;
    private final VersionDTO versionDTO;

    private Version() {
        Properties projectProperties = new Properties();
        try (InputStream inputStream = Version.class.getClassLoader().getResourceAsStream("gravitino-build-info.properties");){
            if (inputStream == null) {
                throw new GravitinoRuntimeException(new IOException("Resource gravitino-build-info.properties not found"), "Failed to get Gravitino version: Build info properties file is missing.", new Object[0]);
            }
            VersionInfo currentVersionInfo = new VersionInfo();
            projectProperties.load(inputStream);
            currentVersionInfo.version = projectProperties.getProperty("project.version");
            currentVersionInfo.compileDate = projectProperties.getProperty("compile.date");
            currentVersionInfo.gitCommit = projectProperties.getProperty("git.commit.id");
            this.versionInfo = currentVersionInfo;
            this.versionDTO = new VersionDTO(currentVersionInfo.version, currentVersionInfo.compileDate, currentVersionInfo.gitCommit);
        }
        catch (IOException e) {
            throw new GravitinoRuntimeException(e, "Failed to get Gravitino version", new Object[0]);
        }
    }

    public static VersionInfo getCurrentVersion() {
        return Version.INSTANCE.versionInfo;
    }

    public static VersionDTO getCurrentVersionDTO() {
        return Version.INSTANCE.versionDTO;
    }

    public static int[] parseVersionNumber(String versionString) {
        Preconditions.checkArgument(StringUtils.isNotBlank(versionString), "Version string is null or empty");
        Matcher matcher = PATTERN.matcher(versionString);
        if (matcher.matches()) {
            int[] versionNumbers = new int[3];
            for (int i = 0; i < 3; ++i) {
                versionNumbers[i] = Integer.parseInt(matcher.group(i + 1));
            }
            return versionNumbers;
        }
        throw new GravitinoRuntimeException("Invalid version string " + versionString);
    }

    public static class VersionInfo {
        public String version;
        public String compileDate;
        public String gitCommit;
    }
}

