/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel.partitions;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.dto.rel.expressions.LiteralDTO;
import org.apache.gravitino.dto.rel.partitions.PartitionDTO;
import org.apache.gravitino.rel.partitions.ListPartition;

public class ListPartitionDTO
implements PartitionDTO,
ListPartition {
    private final String name;
    private final LiteralDTO[][] lists;
    private final Map<String, String> properties;

    public static Builder builder() {
        return new Builder();
    }

    private ListPartitionDTO() {
        this(null, null, null);
    }

    private ListPartitionDTO(String name, LiteralDTO[][] lists, Map<String, String> properties) {
        this.name = name;
        this.lists = lists;
        this.properties = properties;
    }

    public String name() {
        return this.name;
    }

    public LiteralDTO[][] lists() {
        return this.lists;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public PartitionDTO.Type type() {
        return PartitionDTO.Type.LIST;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListPartitionDTO)) {
            return false;
        }
        ListPartitionDTO that = (ListPartitionDTO)o;
        return Objects.equals(this.name, that.name) && Arrays.deepEquals((Object[])this.lists, (Object[])that.lists) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.properties);
        result = 31 * result + Arrays.deepHashCode((Object[])this.lists);
        return result;
    }

    public static class Builder {
        private String name;
        private LiteralDTO[][] lists;
        private Map<String, String> properties;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withLists(LiteralDTO[][] lists) {
            this.lists = lists;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public ListPartitionDTO build() {
            return new ListPartitionDTO(this.name, this.lists, this.properties);
        }
    }
}

