/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.build.dependencies;

import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.Optional;
import org.grails.forge.build.dependencies.Coordinate;
import org.grails.forge.build.dependencies.CoordinateResolver;

@Singleton
@Primary
public class DefaultCoordinateResolver
implements CoordinateResolver {
    private final CoordinateResolver[] coordinateResolvers;

    public DefaultCoordinateResolver(CoordinateResolver[] coordinateResolvers) {
        this.coordinateResolvers = coordinateResolvers;
    }

    @Override
    @NonNull
    public Optional<Coordinate> resolve(@NonNull String artifactId) {
        return Arrays.stream(this.coordinateResolvers).map(resolver -> resolver.resolve(artifactId)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }
}

