/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.confluent.kafka.serializers.KafkaJsonSerializerConfig;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaJsonSerializer<T>
implements Serializer<T> {
    private ObjectMapper objectMapper;

    public void configure(Map<String, ?> config, boolean isKey) {
        this.configure(new KafkaJsonSerializerConfig(config));
    }

    protected void configure(KafkaJsonSerializerConfig config) {
        boolean prettyPrint = config.getBoolean("json.indent.output");
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, prettyPrint);
    }

    public byte[] serialize(String topic, T data) {
        try {
            return this.objectMapper.writeValueAsBytes(data);
        }
        catch (Exception e) {
            throw new SerializationException("Error serializing JSON message", (Throwable)e);
        }
    }

    public void close() {
    }
}

