/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyContext {
    private static final Logger log = LoggerFactory.getLogger(CopyContext.class);
    private final Cache<Path, Optional<FileStatus>> fileStatusCache = CacheBuilder.newBuilder().recordStats().maximumSize(10000L).build();

    public Optional<FileStatus> getFileStatus(final FileSystem fs, final Path path) throws IOException {
        try {
            return (Optional)this.fileStatusCache.get((Object)fs.makeQualified(path), (Callable)new Callable<Optional<FileStatus>>(){

                @Override
                public Optional<FileStatus> call() throws Exception {
                    try {
                        return Optional.of((Object)fs.getFileStatus(path));
                    }
                    catch (FileNotFoundException fnfe) {
                        return Optional.absent();
                    }
                }
            });
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
    }

    public void logCacheStatistics() {
        log.info(this.fileStatusCache.stats().toString());
    }
}

