/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.task;

import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.conversion.hive.entities.QueryBasedHivePublishEntity;
import org.apache.gobblin.data.management.conversion.hive.source.HiveSource;
import org.apache.gobblin.data.management.conversion.hive.source.HiveWorkUnit;
import org.apache.gobblin.data.management.conversion.hive.watermarker.HiveSourceWatermarker;
import org.apache.gobblin.data.management.conversion.hive.watermarker.HiveSourceWatermarkerFactory;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.runtime.TaskContext;
import org.apache.gobblin.runtime.task.BaseAbstractTask;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.HiveJdbcConnector;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiveTask
extends BaseAbstractTask {
    private static final Logger log = LoggerFactory.getLogger(HiveTask.class);
    private static final String USE_WATERMARKER_KEY = "internal.hiveTask.useWatermarker";
    private static final String ADD_FILES = "internal.hiveTask.addFiles";
    private static final String ADD_JARS = "internal.hiveTask.addJars";
    private static final String SETUP_QUERIES = "internal.hiveTask.setupQueries";
    protected final TaskContext taskContext;
    protected final WorkUnitState workUnitState;
    protected final HiveWorkUnit workUnit;
    protected final EventSubmitter eventSubmitter;
    protected final List<String> hiveExecutionQueries;
    protected final QueryBasedHivePublishEntity publishEntity;
    protected final HiveJdbcConnector hiveJdbcConnector;
    private final List<String> addFiles;
    private final List<String> addJars;
    private final List<String> setupQueries;

    public static void disableHiveWatermarker(State state) {
        state.setProp(USE_WATERMARKER_KEY, (Object)Boolean.toString(false));
    }

    public static void addFile(State state, String file) {
        state.setProp(ADD_FILES, (Object)(state.getProp(ADD_FILES, "") + "," + file));
    }

    public static void addJar(State state, String jar) {
        state.setProp(ADD_JARS, (Object)(state.getProp(ADD_JARS, "") + "," + jar));
    }

    public static void addSetupQuery(State state, String query) {
        state.setProp(SETUP_QUERIES, (Object)(state.getProp(SETUP_QUERIES, "") + ";" + query));
    }

    public HiveTask(TaskContext taskContext) {
        super(taskContext);
        this.taskContext = taskContext;
        this.workUnitState = taskContext.getTaskState();
        this.workUnit = new HiveWorkUnit(this.workUnitState.getWorkunit());
        this.eventSubmitter = new EventSubmitter.Builder(this.metricContext, "gobblin.HiveTask").build();
        this.hiveExecutionQueries = Lists.newArrayList();
        this.publishEntity = new QueryBasedHivePublishEntity();
        try {
            this.hiveJdbcConnector = HiveJdbcConnector.newConnectorWithProps((Properties)this.workUnitState.getProperties());
        }
        catch (SQLException se) {
            throw new RuntimeException("Error in creating JDBC Connector", se);
        }
        this.addFiles = this.workUnitState.getPropAsList(ADD_FILES, "");
        this.addJars = this.workUnitState.getPropAsList(ADD_JARS, "");
        this.setupQueries = Splitter.on((String)";").trimResults().omitEmptyStrings().splitToList((CharSequence)this.workUnitState.getProp(SETUP_QUERIES, ""));
    }

    public abstract List<String> generateHiveQueries() throws Exception;

    public abstract QueryBasedHivePublishEntity generatePublishQueries() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executePublishQueries(QueryBasedHivePublishEntity publishEntity) {
        LinkedHashSet cleanUpQueries = Sets.newLinkedHashSet();
        LinkedHashSet publishQueries = Sets.newLinkedHashSet();
        ArrayList directoriesToDelete = Lists.newArrayList();
        FileSystem fs = null;
        try {
            fs = HiveSource.getSourceFs((State)this.workUnitState);
            if (publishEntity.getCleanupQueries() != null) {
                cleanUpQueries.addAll(publishEntity.getCleanupQueries());
            }
            if (publishEntity.getCleanupDirectories() != null) {
                directoriesToDelete.addAll(publishEntity.getCleanupDirectories());
            }
            if (publishEntity.getPublishDirectories() != null) {
                Map<String, String> publishDirectories = publishEntity.getPublishDirectories();
                try {
                    for (Map.Entry<String, String> publishDir : publishDirectories.entrySet()) {
                        HadoopUtils.renamePath((FileSystem)fs, (Path)new Path(publishDir.getKey()), (Path)new Path(publishDir.getValue()), (boolean)true);
                    }
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
            if (publishEntity.getPublishQueries() != null) {
                publishQueries.addAll(publishEntity.getPublishQueries());
            }
            WorkUnitState wus = this.workUnitState;
            this.hiveJdbcConnector.executeStatements(publishQueries.toArray(new String[publishQueries.size()]));
            wus.setWorkingState(WorkUnitState.WorkingState.COMMITTED);
            if (wus.getPropAsBoolean(USE_WATERMARKER_KEY, true)) {
                HiveSourceWatermarker watermarker = ((HiveSourceWatermarkerFactory)GobblinConstructorUtils.invokeConstructor(HiveSourceWatermarkerFactory.class, (String)wus.getProp("hive.source.watermarker.factoryClass", HiveSource.DEFAULT_HIVE_SOURCE_WATERMARKER_FACTORY_CLASS), (Object[])new Object[0])).createFromState((State)wus);
                watermarker.setActualHighWatermark(wus);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("Error in HiveMaterializer generate publish queries", (Throwable)e);
        }
        finally {
            try {
                this.hiveJdbcConnector.executeStatements(cleanUpQueries.toArray(new String[cleanUpQueries.size()]));
                HadoopUtils.deleteDirectories((FileSystem)fs, (List)directoriesToDelete, (boolean)true, (boolean)true);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                log.error("Failed to cleanup staging entities.", (Throwable)e);
            }
        }
    }

    public void run() {
        try {
            List<String> queries = this.generateHiveQueries();
            this.hiveJdbcConnector.executeStatements(Lists.transform(this.addFiles, file -> "ADD FILE " + file).toArray(new String[0]));
            this.hiveJdbcConnector.executeStatements(Lists.transform(this.addJars, file -> "ADD JAR " + file).toArray(new String[0]));
            this.hiveJdbcConnector.executeStatements(this.setupQueries.toArray(new String[0]));
            this.hiveJdbcConnector.executeStatements(queries.toArray(new String[queries.size()]));
            super.run();
        }
        catch (Exception e) {
            this.workingState = WorkUnitState.WorkingState.FAILED;
            log.error("Exception in HiveTask generateHiveQueries ", (Throwable)e);
        }
    }

    public void commit() {
        try {
            this.executePublishQueries(this.generatePublishQueries());
            super.commit();
        }
        catch (Exception e) {
            this.workingState = WorkUnitState.WorkingState.FAILED;
            log.error("Exception in HiveTask generate publish HiveQueries ", (Throwable)e);
        }
    }
}

