/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore;

import com.typesafe.config.Config;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.MysqlStateStore;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.util.ConfigUtils;

@Alias(value="mysql")
public class MysqlStateStoreFactory
implements StateStore.Factory {
    @Override
    public <T extends State> StateStore<T> createStateStore(Config config, Class<T> stateClass) {
        BasicDataSource basicDataSource = MysqlStateStore.newDataSource(config);
        String stateStoreTableName = ConfigUtils.getString((Config)config, (String)"state.store.db.table", (String)"gobblin_job_state");
        boolean compressedValues = ConfigUtils.getBoolean((Config)config, (String)"state.store.compressedValues", (boolean)true);
        try {
            return new MysqlStateStore<T>((DataSource)basicDataSource, stateStoreTableName, compressedValues, stateClass);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create MysqlStateStore with factory", e);
        }
    }
}

