/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import com.microsoft.azure.servicebus.amqp.IAmqpLink;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;

public class BaseLinkHandler
extends BaseHandler {
    protected static final Logger TRACE_LOGGER = Logger.getLogger("servicebus.trace");
    private final IAmqpLink underlyingEntity;

    public BaseLinkHandler(IAmqpLink amqpLink) {
        this.underlyingEntity = amqpLink;
    }

    public void onLinkLocalClose(Event event) {
        Link link = event.getLink();
        if (link != null && TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, String.format("linkName[%s]", link.getName()));
        }
    }

    public void onLinkRemoteClose(Event event) {
        Link link = event.getLink();
        if (link.getLocalState() != EndpointState.CLOSED) {
            link.close();
        }
        if (link != null) {
            ErrorCondition condition = link.getRemoteCondition();
            this.processOnClose(link, condition);
        }
    }

    public void onLinkRemoteDetach(Event event) {
        Link link = event.getLink();
        if (link.getLocalState() != EndpointState.CLOSED) {
            link.close();
        }
        if (link != null) {
            this.processOnClose(link, link.getRemoteCondition());
        }
    }

    public void processOnClose(Link link, ErrorCondition condition) {
        if (condition != null && TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, "linkName[" + link.getName() + (condition != null ? "], ErrorCondition[" + condition.getCondition() + ", " + condition.getDescription() + "]" : "], condition[null]"));
        }
        this.underlyingEntity.onClose(condition);
    }

    public void processOnClose(Link link, Exception exception) {
        this.underlyingEntity.onError(exception);
    }
}

