/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.d2.discovery.PropertySerializationException;
import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.d2.discovery.stores.zk.AbstractZooKeeper;
import com.linkedin.d2.discovery.stores.zk.SymlinkUtil;
import com.linkedin.d2.discovery.stores.zk.ZooKeeper;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymlinkAwareZooKeeper
extends AbstractZooKeeper {
    private static final Logger LOG = LoggerFactory.getLogger(SymlinkAwareZooKeeper.class);
    private final PropertySerializer<String> _serializer;
    private final Watcher _defaultWatcher;

    public SymlinkAwareZooKeeper(ZooKeeper zk, Watcher watcher) {
        this(zk, watcher, new DefaultSerializer());
    }

    public SymlinkAwareZooKeeper(ZooKeeper zk, Watcher watcher, PropertySerializer<String> serializer) {
        super(zk);
        this._defaultWatcher = watcher;
        this._serializer = serializer;
    }

    @Override
    public void exists(String path, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        if (!SymlinkUtil.containsSymlink(path)) {
            this._zk.exists(path, watch, cb, ctx);
        } else {
            SymlinkStatCallback compositeCallback = new SymlinkStatCallback(path, this._defaultWatcher, cb);
            this.exists0(path, watch ? compositeCallback : null, compositeCallback, ctx);
        }
    }

    @Override
    public void exists(String path, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        if (!SymlinkUtil.containsSymlink(path)) {
            this._zk.exists(path, watcher, cb, ctx);
        } else {
            SymlinkStatCallback compositeCallback = new SymlinkStatCallback(path, watcher, cb);
            this.exists0(path, watcher != null ? compositeCallback : null, compositeCallback, ctx);
        }
    }

    @Override
    public void getChildren(String path, boolean watch, AsyncCallback.ChildrenCallback cb, Object ctx) {
        if (!SymlinkUtil.containsSymlink(path)) {
            this._zk.getChildren(path, watch, cb, ctx);
        } else {
            SymlinkChildrenCallback compositeCallback = new SymlinkChildrenCallback(path, this._defaultWatcher, cb);
            this.getChildren0(path, watch ? compositeCallback : null, compositeCallback, ctx);
        }
    }

    @Override
    public void getChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        if (!SymlinkUtil.containsSymlink(path)) {
            this._zk.getChildren(path, watcher, cb, ctx);
        } else {
            SymlinkChildrenCallback compositeCallback = new SymlinkChildrenCallback(path, watcher, cb);
            this.getChildren0(path, watcher != null ? compositeCallback : null, compositeCallback, ctx);
        }
    }

    @Override
    public void getChildren(String path, Watcher watcher, AsyncCallback.Children2Callback cb, Object ctx) {
        if (!SymlinkUtil.containsSymlink(path)) {
            this._zk.getChildren(path, watcher, cb, ctx);
        } else {
            SymlinkChildren2Callback compositeCallback = new SymlinkChildren2Callback(path, watcher, cb);
            this.getChildren2(path, watcher != null ? compositeCallback : null, compositeCallback, ctx);
        }
    }

    @Override
    public void getData(String path, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        if (!SymlinkUtil.containsSymlink(path)) {
            this._zk.getData(path, watch, cb, ctx);
        } else {
            SymlinkDataCallback compositeCallback = new SymlinkDataCallback(path, this._defaultWatcher, cb);
            this.getData0(path, watch ? compositeCallback : null, compositeCallback, ctx);
        }
    }

    @Override
    public void getData(String path, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        if (!SymlinkUtil.containsSymlink(path)) {
            this._zk.getData(path, watcher, cb, ctx);
        } else {
            SymlinkDataCallback compositeCallback = new SymlinkDataCallback(path, watcher, cb);
            this.getData0(path, watcher != null ? compositeCallback : null, compositeCallback, ctx);
        }
    }

    public void rawGetData(String path, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this._zk.getData(path, watch, cb, ctx);
    }

    public void rawGetData(String path, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        this._zk.getData(path, watcher, cb, ctx);
    }

    public void rawExists(String path, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        this._zk.exists(path, watch, cb, ctx);
    }

    public void rawExists(String path, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        this._zk.exists(path, watcher, cb, ctx);
    }

    public void rawGetChildren(String path, boolean watch, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this._zk.getChildren(path, watch, cb, ctx);
    }

    public void rawGetChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this._zk.getChildren(path, watcher, cb, ctx);
    }

    private void getData0(String path, final SymlinkWatcher watcher, final AsyncCallback.DataCallback cb, Object ctx) {
        int index = SymlinkUtil.firstSymlinkIndex(path);
        if (index < 0) {
            this._zk.getData(path, watcher, cb, ctx);
        } else {
            String symlink = path.substring(0, index);
            final String remainPath = path.substring(index);
            AsyncCallback.DataCallback resolveCallback = new AsyncCallback.DataCallback(){

                public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                    KeeperException.Code result = KeeperException.Code.get((int)rc);
                    switch (result) {
                        case OK: {
                            try {
                                String realPath = (String)SymlinkAwareZooKeeper.this._serializer.fromBytes(data);
                                SymlinkAwareZooKeeper.this.getData0(realPath + remainPath, watcher, cb, ctx);
                            }
                            catch (Exception e) {
                                if (watcher != null) {
                                    watcher.disable();
                                }
                                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null, null);
                                LOG.warn("Exception when resolving symlink: " + path, (Throwable)e);
                            }
                            break;
                        }
                        default: {
                            if (watcher != null) {
                                watcher.disable();
                            }
                            cb.processResult(rc, path, ctx, data, stat);
                        }
                    }
                }
            };
            this._zk.getData(symlink, watcher, resolveCallback, ctx);
        }
    }

    private void exists0(final String path, final SymlinkWatcher watcher, final AsyncCallback.StatCallback cb, final Object ctx) {
        int index = SymlinkUtil.firstSymlinkIndex(path);
        if (index < 0) {
            this._zk.exists(path, watcher, cb, ctx);
        } else {
            String symlink = path.substring(0, index);
            final String remainPath = path.substring(index);
            AsyncCallback.DataCallback resolveCallback = new AsyncCallback.DataCallback(){

                public void processResult(int rc, String p, Object c, byte[] data, Stat s) {
                    KeeperException.Code result = KeeperException.Code.get((int)rc);
                    switch (result) {
                        case OK: {
                            try {
                                String realPath = (String)SymlinkAwareZooKeeper.this._serializer.fromBytes(data);
                                SymlinkAwareZooKeeper.this.exists0(realPath + remainPath, watcher, cb, ctx);
                            }
                            catch (Exception e) {
                                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
                                LOG.warn("Exception when resolving symlink: " + path, (Throwable)e);
                            }
                            break;
                        }
                        case NONODE: {
                            AsyncCallback.StatCallback existsCallback = new AsyncCallback.StatCallback(){

                                public void processResult(int rc, String p, Object c, Stat s) {
                                    KeeperException.Code code = KeeperException.Code.get((int)rc);
                                    switch (code) {
                                        case OK: {
                                            SymlinkAwareZooKeeper.this.exists0(path, watcher, cb, ctx);
                                            break;
                                        }
                                        case NONODE: {
                                            cb.processResult(rc, path, ctx, s);
                                            break;
                                        }
                                        default: {
                                            if (watcher != null) {
                                                watcher.disable();
                                            }
                                            cb.processResult(rc, path, ctx, s);
                                        }
                                    }
                                }
                            };
                            SymlinkAwareZooKeeper.this._zk.exists(p, watcher, existsCallback, ctx);
                            break;
                        }
                        default: {
                            if (watcher != null) {
                                watcher.disable();
                            }
                            cb.processResult(rc, path, ctx, s);
                        }
                    }
                }
            };
            this._zk.getData(symlink, watcher, resolveCallback, ctx);
        }
    }

    private void getChildren0(String path, final SymlinkWatcher watcher, final AsyncCallback.ChildrenCallback cb, Object ctx) {
        int index = SymlinkUtil.firstSymlinkIndex(path);
        if (index < 0) {
            this._zk.getChildren(path, (Watcher)watcher, cb, ctx);
        } else {
            String symlink = path.substring(0, index);
            final String remainPath = path.substring(index);
            AsyncCallback.DataCallback resolveCallback = new AsyncCallback.DataCallback(){

                public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                    KeeperException.Code result = KeeperException.Code.get((int)rc);
                    switch (result) {
                        case OK: {
                            try {
                                String realPath = (String)SymlinkAwareZooKeeper.this._serializer.fromBytes(data);
                                SymlinkAwareZooKeeper.this.getChildren0(realPath + remainPath, watcher, cb, ctx);
                            }
                            catch (Exception e) {
                                if (watcher != null) {
                                    watcher.disable();
                                }
                                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, Collections.emptyList());
                                LOG.warn("Exception when resolving symlink: " + path, (Throwable)e);
                            }
                            break;
                        }
                        default: {
                            if (watcher != null) {
                                watcher.disable();
                            }
                            cb.processResult(rc, path, ctx, Collections.emptyList());
                        }
                    }
                }
            };
            this._zk.getData(symlink, watcher, resolveCallback, ctx);
        }
    }

    private void getChildren2(String path, final SymlinkWatcher watcher, final AsyncCallback.Children2Callback cb, Object ctx) {
        int index = SymlinkUtil.firstSymlinkIndex(path);
        if (index < 0) {
            this._zk.getChildren(path, (Watcher)watcher, cb, ctx);
        } else {
            String symlink = path.substring(0, index);
            final String remainPath = path.substring(index);
            AsyncCallback.DataCallback resolveCallback = new AsyncCallback.DataCallback(){

                public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                    KeeperException.Code result = KeeperException.Code.get((int)rc);
                    switch (result) {
                        case OK: {
                            try {
                                String realPath = (String)SymlinkAwareZooKeeper.this._serializer.fromBytes(data);
                                SymlinkAwareZooKeeper.this.getChildren2(realPath + remainPath, watcher, cb, ctx);
                            }
                            catch (Exception e) {
                                if (watcher != null) {
                                    watcher.disable();
                                }
                                cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, Collections.emptyList(), null);
                                LOG.warn("Exception when resolving symlink: " + path, (Throwable)e);
                            }
                            break;
                        }
                        default: {
                            if (watcher != null) {
                                watcher.disable();
                            }
                            cb.processResult(rc, path, ctx, Collections.emptyList(), null);
                        }
                    }
                }
            };
            this._zk.getData(symlink, watcher, resolveCallback, ctx);
        }
    }

    public static class DefaultSerializer
    implements PropertySerializer<String> {
        @Override
        public String fromBytes(byte[] bytes) throws PropertySerializationException {
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new PropertySerializationException(e);
            }
        }

        @Override
        public byte[] toBytes(String property) {
            try {
                return property.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class SymlinkChildren2Callback
    extends SymlinkWatcher
    implements AsyncCallback.Children2Callback {
        private final AsyncCallback.Children2Callback _callback;

        public SymlinkChildren2Callback(String rawPath, Watcher watch, AsyncCallback.Children2Callback cb) {
            super(watch, rawPath);
            this._callback = cb;
        }

        public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
            this._callback.processResult(rc, this._rawPath, ctx, children, stat);
            this._callbackInvoked = true;
            if (this._pendingEvent != null) {
                this._watch.process(this._pendingEvent);
            }
        }

        @Override
        public WatchedEvent newWatchedEvent(WatchedEvent event) {
            if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                return new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, event.getState(), this._rawPath);
            }
            return new WatchedEvent(event.getType(), event.getState(), this._rawPath);
        }
    }

    private class SymlinkChildrenCallback
    extends SymlinkWatcher
    implements AsyncCallback.ChildrenCallback {
        private final AsyncCallback.ChildrenCallback _callback;

        public SymlinkChildrenCallback(String rawPath, Watcher watch, AsyncCallback.ChildrenCallback cb) {
            super(watch, rawPath);
            this._callback = cb;
        }

        public void processResult(int rc, String path, Object ctx, List<String> children) {
            this._callback.processResult(rc, this._rawPath, ctx, children);
            this._callbackInvoked = true;
            if (this._pendingEvent != null) {
                this._watch.process(this._pendingEvent);
            }
        }

        @Override
        public WatchedEvent newWatchedEvent(WatchedEvent event) {
            if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                return new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, event.getState(), this._rawPath);
            }
            return new WatchedEvent(event.getType(), event.getState(), this._rawPath);
        }
    }

    private class SymlinkStatCallback
    extends SymlinkWatcher
    implements AsyncCallback.StatCallback {
        private final AsyncCallback.StatCallback _callback;

        public SymlinkStatCallback(String rawPath, Watcher watch, AsyncCallback.StatCallback cb) {
            super(watch, rawPath);
            this._callback = cb;
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            this._callback.processResult(rc, this._rawPath, ctx, stat);
            this._callbackInvoked = true;
            if (this._pendingEvent != null) {
                this._watch.process(this._pendingEvent);
            }
        }
    }

    private class SymlinkDataCallback
    extends SymlinkWatcher
    implements AsyncCallback.DataCallback {
        private final AsyncCallback.DataCallback _callback;

        public SymlinkDataCallback(String rawPath, Watcher watch, AsyncCallback.DataCallback cb) {
            super(watch, rawPath);
            this._callback = cb;
        }

        public void processResult(int rc, String path, Object ctx, byte[] bytes, Stat stat) {
            this._callback.processResult(rc, this._rawPath, ctx, bytes, stat);
            this._callbackInvoked = true;
            if (this._pendingEvent != null) {
                this._watch.process(this._pendingEvent);
            }
        }
    }

    private abstract class SymlinkWatcher
    implements Watcher {
        protected final Watcher _watch;
        protected final String _rawPath;
        protected AtomicBoolean _disabled = new AtomicBoolean();
        protected volatile WatchedEvent _pendingEvent;
        protected volatile boolean _callbackInvoked = false;

        public SymlinkWatcher(Watcher watch, String rawPath) {
            this._watch = watch;
            this._rawPath = rawPath;
            this._pendingEvent = null;
        }

        public void process(WatchedEvent event) {
            if (this._disabled.getAndSet(true)) {
                return;
            }
            WatchedEvent newEvent = this.newWatchedEvent(event);
            if (this._callbackInvoked) {
                this._watch.process(newEvent);
            } else {
                this._pendingEvent = newEvent;
            }
        }

        public void disable() {
            this._disabled.set(true);
            this._pendingEvent = null;
        }

        protected WatchedEvent newWatchedEvent(WatchedEvent event) {
            return new WatchedEvent(event.getType(), event.getState(), this._rawPath);
        }
    }
}

