/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyConfig;
import com.linkedin.d2.balancer.strategies.degrader.MPConsistentHashRingFactory;
import com.linkedin.d2.balancer.strategies.degrader.PointBasedConsistentHashRingFactory;
import com.linkedin.d2.balancer.strategies.degrader.RingFactory;
import com.linkedin.d2.balancer.util.hashing.Ring;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegraderRingFactory<T>
implements RingFactory<T> {
    public static final String POINT_BASED_CONSISTENT_HASH = "pointBased";
    public static final String MULTI_PROBE_CONSISTENT_HASH = "multiProbe";
    private static final Logger _log = LoggerFactory.getLogger(DegraderRingFactory.class);
    private final RingFactory<T> _ringFactory;

    public DegraderRingFactory(DegraderLoadBalancerStrategyConfig config) {
        String consistentHashAlgorithm = config.getConsistentHashAlgorithm();
        if (consistentHashAlgorithm == null || consistentHashAlgorithm.equalsIgnoreCase(POINT_BASED_CONSISTENT_HASH)) {
            this._ringFactory = new PointBasedConsistentHashRingFactory(config);
        } else if (MULTI_PROBE_CONSISTENT_HASH.equalsIgnoreCase(consistentHashAlgorithm)) {
            this._ringFactory = new MPConsistentHashRingFactory(config.getNumProbes());
        } else {
            _log.warn("Unknown consistent hash algorithm {}, falling back to point-based hash ring", (Object)consistentHashAlgorithm);
            this._ringFactory = new PointBasedConsistentHashRingFactory(config);
        }
    }

    @Override
    public Ring<T> createRing(Map<T, Integer> points) {
        return this._ringFactory.createRing(points);
    }
}

