/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.d2.balancer.properties.PartitionProperties;
import com.linkedin.util.ArgumentUtil;

public class RangeBasedPartitionProperties
implements PartitionProperties {
    private final String _partitionKeyRegex;
    private final long _keyRangeStart;
    private final long _partitionSize;
    private final int _partitionCount;

    public RangeBasedPartitionProperties(String partitionKeyRegex, long keyRangeStart, long partitionSize, int partitionCount) {
        ArgumentUtil.notNull((Object)partitionKeyRegex, (String)"partitionKeyRegex");
        this._partitionKeyRegex = partitionKeyRegex;
        this._keyRangeStart = keyRangeStart;
        this._partitionSize = partitionSize;
        this._partitionCount = partitionCount;
    }

    public String getPartitionKeyRegex() {
        return this._partitionKeyRegex;
    }

    public long getKeyRangeStart() {
        return this._keyRangeStart;
    }

    public long getPartitionSize() {
        return this._partitionSize;
    }

    public int getPartitionCount() {
        return this._partitionCount;
    }

    @Override
    public PartitionProperties.PartitionType getPartitionType() {
        return PartitionProperties.PartitionType.RANGE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RangeBasedPartitionProperties other = (RangeBasedPartitionProperties)obj;
        if (!this._partitionKeyRegex.equals(other._partitionKeyRegex)) {
            return false;
        }
        if (this._keyRangeStart != other._keyRangeStart) {
            return false;
        }
        if (this._partitionSize != other._partitionSize) {
            return false;
        }
        return this._partitionCount == other._partitionCount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._partitionKeyRegex == null ? 0 : this._partitionKeyRegex.hashCode());
        result = 31 * result + (int)this._keyRangeStart;
        result = 31 * result + (int)this._partitionSize;
        result = 31 * result + this._partitionCount;
        return result;
    }
}

