/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clients;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.LoadBalancerClient;
import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.d2.balancer.util.LoadBalancerUtil;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.data.ByteString;
import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamException;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.r2.message.stream.entitystream.Observer;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import com.linkedin.util.degrader.CallCompletion;
import com.linkedin.util.degrader.CallTracker;
import com.linkedin.util.degrader.CallTrackerImpl;
import com.linkedin.util.degrader.Degrader;
import com.linkedin.util.degrader.DegraderControl;
import com.linkedin.util.degrader.DegraderImpl;
import com.linkedin.util.degrader.ErrorType;
import java.net.ConnectException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerClient
implements LoadBalancerClient {
    public static final String DEFAULT_ERROR_STATUS_REGEX = "(5..)";
    public static final Pattern DEFAULT_ERROR_STATUS_PATTERN = Pattern.compile("(5..)");
    private static final Logger _log = LoggerFactory.getLogger(TrackerClient.class);
    private final TransportClient _wrappedClient;
    private final Map<Integer, PartitionState> _partitionStates;
    private final CallTracker _callTracker;
    private final URI _uri;
    private final Pattern _errorStatusPattern;

    public TrackerClient(URI uri, Map<Integer, PartitionData> partitionDataMap, TransportClient wrappedClient) {
        this(uri, partitionDataMap, wrappedClient, (Clock)SystemClock.instance(), null, 5000L, DEFAULT_ERROR_STATUS_REGEX);
    }

    public TrackerClient(URI uri, Map<Integer, PartitionData> partitionDataMap, TransportClient wrappedClient, Clock clock, DegraderImpl.Config config) {
        this(uri, partitionDataMap, wrappedClient, clock, config, 5000L, DEFAULT_ERROR_STATUS_REGEX);
    }

    public TrackerClient(URI uri, Map<Integer, PartitionData> partitionDataMap, TransportClient wrappedClient, Clock clock, DegraderImpl.Config config, long interval, String errorStatusRegex) {
        Pattern errorPattern;
        this._uri = uri;
        this._wrappedClient = wrappedClient;
        this._callTracker = new CallTrackerImpl(interval, clock);
        try {
            errorPattern = Pattern.compile(errorStatusRegex != null ? errorStatusRegex : DEFAULT_ERROR_STATUS_REGEX);
        }
        catch (PatternSyntaxException ex) {
            _log.warn("Invalid error status regex: {}. Falling back to default regex: {}", (Object)errorStatusRegex, (Object)DEFAULT_ERROR_STATUS_REGEX);
            errorPattern = DEFAULT_ERROR_STATUS_PATTERN;
        }
        this._errorStatusPattern = errorPattern;
        if (config == null) {
            config = new DegraderImpl.Config();
        }
        config.setCallTracker(this._callTracker);
        config.setClock(clock);
        config.setOverrideDropRate(Double.valueOf(0.0));
        int mapSize = partitionDataMap.size();
        HashMap<Integer, PartitionState> partitionStates = new HashMap<Integer, PartitionState>(mapSize * 2);
        config.setName("TrackerClient Degrader: " + uri);
        DegraderImpl degrader = new DegraderImpl(config);
        DegraderControl degraderControl = new DegraderControl(degrader);
        for (Map.Entry<Integer, PartitionData> entry : partitionDataMap.entrySet()) {
            int partitionId = entry.getKey();
            PartitionState partitionState = new PartitionState(entry.getValue(), (Degrader)degrader, degraderControl);
            partitionStates.put(partitionId, partitionState);
        }
        this._partitionStates = Collections.unmodifiableMap(partitionStates);
        LogUtil.debug(_log, "created tracker client: ", this);
    }

    public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
        this._wrappedClient.restRequest(request, requestContext, wireAttrs, (TransportCallback)new TrackerClientRestCallback(callback, this._callTracker.startCall()));
    }

    public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
        this._wrappedClient.streamRequest(request, requestContext, wireAttrs, (TransportCallback)new TrackerClientStreamCallback(callback, this._callTracker.startCall()));
    }

    public void shutdown(Callback<None> callback) {
        this._wrappedClient.shutdown(callback);
    }

    public Double getPartitionWeight(int partitionId) {
        PartitionData partitionData = this.getPartitionState(partitionId).getPartitionData();
        return partitionData == null ? null : Double.valueOf(partitionData.getWeight());
    }

    public TransportClient getWrappedClient() {
        return this._wrappedClient;
    }

    public CallTracker getCallTracker() {
        return this._callTracker;
    }

    public Degrader getDegrader(int partitionId) {
        return this.getPartitionState(partitionId).getDegrader();
    }

    public DegraderControl getDegraderControl(int partitionId) {
        return this.getPartitionState(partitionId).getDegraderControl();
    }

    public Map<Integer, PartitionData> getParttitionDataMap() {
        HashMap<Integer, PartitionData> partitionDataMap = new HashMap<Integer, PartitionData>();
        for (Map.Entry<Integer, PartitionState> entry : this._partitionStates.entrySet()) {
            partitionDataMap.put(entry.getKey(), entry.getValue().getPartitionData());
        }
        return partitionDataMap;
    }

    private PartitionState getPartitionState(int partitionId) {
        PartitionState partitionState = this._partitionStates.get(partitionId);
        if (partitionState == null) {
            String msg = "PartitionState does not exist for partitionId: " + partitionId + ". The current states are " + this._partitionStates;
            throw new IllegalStateException(msg);
        }
        return partitionState;
    }

    @Override
    public URI getUri() {
        return this._uri;
    }

    public String toString() {
        return "TrackerClient [_callTracker=" + this._callTracker + ", _uri=" + this._uri + ", _partitionStates=" + this._partitionStates + ", _wrappedClient=" + this._wrappedClient + "]";
    }

    private void handleError(CallCompletion callCompletion, Throwable throwable) {
        if (this.isServerError(throwable)) {
            callCompletion.endCallWithError(ErrorType.SERVER_ERROR);
        } else if (throwable instanceof RemoteInvocationException) {
            Throwable originalThrowable = LoadBalancerUtil.findOriginalThrowable(throwable);
            if (originalThrowable instanceof ConnectException) {
                callCompletion.endCallWithError(ErrorType.CONNECT_EXCEPTION);
            } else if (originalThrowable instanceof ClosedChannelException) {
                callCompletion.endCallWithError(ErrorType.CLOSED_CHANNEL_EXCEPTION);
            } else if (originalThrowable instanceof TimeoutException) {
                callCompletion.endCallWithError(ErrorType.TIMEOUT_EXCEPTION);
            } else {
                callCompletion.endCallWithError(ErrorType.REMOTE_INVOCATION_EXCEPTION);
            }
        } else {
            callCompletion.endCallWithError();
        }
    }

    private boolean isServerError(Throwable throwable) {
        StreamException streamException;
        if (throwable instanceof RestException) {
            RestException restException = (RestException)throwable;
            if (restException.getResponse() != null) {
                return this.matchErrorStatus(restException.getResponse().getStatus());
            }
        } else if (throwable instanceof StreamException && (streamException = (StreamException)throwable).getResponse() != null) {
            return this.matchErrorStatus(streamException.getResponse().getStatus());
        }
        return false;
    }

    private boolean matchErrorStatus(int status) {
        return this._errorStatusPattern.matcher(Integer.toString(status)).matches();
    }

    private class PartitionState {
        private final Degrader _degrader;
        private final DegraderControl _degraderControl;
        private final PartitionData _partitionData;

        PartitionState(PartitionData partitionData, Degrader degrader, DegraderControl degraderControl) {
            this._partitionData = partitionData;
            this._degrader = degrader;
            this._degraderControl = degraderControl;
        }

        Degrader getDegrader() {
            return this._degrader;
        }

        DegraderControl getDegraderControl() {
            return this._degraderControl;
        }

        PartitionData getPartitionData() {
            return this._partitionData;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{_partitionData = ");
            sb.append(this._partitionData);
            sb.append("_degrader = " + this._degrader);
            sb.append("degraderMinCallCount = " + this._degraderControl.getMinCallCount());
            sb.append("}");
            return sb.toString();
        }
    }

    private class TrackerClientStreamCallback
    implements TransportCallback<StreamResponse> {
        private TransportCallback<StreamResponse> _wrappedCallback;
        private CallCompletion _callCompletion;

        public TrackerClientStreamCallback(TransportCallback<StreamResponse> wrappedCallback, CallCompletion callCompletion) {
            this._wrappedCallback = wrappedCallback;
            this._callCompletion = callCompletion;
        }

        public void onResponse(TransportResponse<StreamResponse> response) {
            if (response.hasError()) {
                Throwable throwable = response.getError();
                TrackerClient.this.handleError(this._callCompletion, throwable);
            } else {
                EntityStream entityStream = ((StreamResponse)response.getResponse()).getEntityStream();
                this._callCompletion.record();
                Observer observer = new Observer(){

                    public void onDataAvailable(ByteString data) {
                    }

                    public void onDone() {
                        TrackerClientStreamCallback.this._callCompletion.endCall();
                    }

                    public void onError(Throwable e) {
                        TrackerClient.this.handleError(TrackerClientStreamCallback.this._callCompletion, e);
                    }
                };
                entityStream.addObserver(observer);
            }
            this._wrappedCallback.onResponse(response);
        }
    }

    private class TrackerClientRestCallback
    implements TransportCallback<RestResponse> {
        private TransportCallback<RestResponse> _wrappedCallback;
        private CallCompletion _callCompletion;

        public TrackerClientRestCallback(TransportCallback<RestResponse> wrappedCallback, CallCompletion callCompletion) {
            this._wrappedCallback = wrappedCallback;
            this._callCompletion = callCompletion;
        }

        public void onResponse(TransportResponse<RestResponse> response) {
            if (response.hasError()) {
                Throwable throwable = response.getError();
                TrackerClient.this.handleError(this._callCompletion, throwable);
            } else {
                this._callCompletion.endCall();
            }
            this._wrappedCallback.onResponse(response);
        }
    }
}

