/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.multiplexer;

import com.linkedin.restli.common.ErrorResponse;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.multiplexer.IndividualBody;
import com.linkedin.restli.common.multiplexer.IndividualResponse;
import com.linkedin.restli.internal.server.response.ErrorResponseBuilder;
import com.linkedin.restli.server.RestLiServiceException;

final class IndividualResponseException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final IndividualResponse _response;

    public IndividualResponseException(HttpStatus status, String message) {
        super(message);
        this._response = IndividualResponseException.createErrorIndividualResponse(status, IndividualResponseException.createErrorResponse(status, message));
    }

    public IndividualResponseException(HttpStatus status, String message, Throwable e) {
        super(message, e);
        this._response = IndividualResponseException.createErrorIndividualResponse(status, IndividualResponseException.createErrorResponse(status, message));
    }

    public IndividualResponseException(RestLiServiceException e) {
        super(e);
        this._response = IndividualResponseException.createErrorIndividualResponse(e.getStatus(), IndividualResponseException.createErrorResponse(e));
    }

    public IndividualResponse getResponse() {
        return this._response;
    }

    public static IndividualResponse createInternalServerErrorIndividualResponse(Throwable e) {
        return IndividualResponseException.createInternalServerErrorIndividualResponse(e.getMessage());
    }

    public static IndividualResponse createInternalServerErrorIndividualResponse(String message) {
        ErrorResponse errorResponse = null;
        if (message != null && !message.isEmpty()) {
            errorResponse = IndividualResponseException.createErrorResponse(HttpStatus.S_500_INTERNAL_SERVER_ERROR, message);
        }
        return IndividualResponseException.createErrorIndividualResponse(HttpStatus.S_500_INTERNAL_SERVER_ERROR, errorResponse);
    }

    public static IndividualResponse createErrorIndividualResponse(RestLiServiceException e) {
        return IndividualResponseException.createErrorIndividualResponse(e.getStatus(), IndividualResponseException.createErrorResponse(e));
    }

    private static IndividualResponse createErrorIndividualResponse(HttpStatus status, ErrorResponse errorResponse) {
        IndividualResponse response = new IndividualResponse();
        response.setStatus(status.getCode());
        if (errorResponse != null) {
            response.setBody(new IndividualBody(errorResponse.data()));
        }
        return response;
    }

    private static ErrorResponse createErrorResponse(HttpStatus status, String message) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setStatus(status.getCode());
        errorResponse.setMessage(message);
        return errorResponse;
    }

    private static ErrorResponse createErrorResponse(RestLiServiceException e) {
        return new ErrorResponseBuilder().buildErrorResponse(e);
    }
}

