/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive.metastore;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.hive.HivePartition;
import org.apache.gobblin.hive.HiveTable;
import org.apache.gobblin.hive.spec.HiveSpec;
import org.apache.gobblin.metrics.event.EventSubmitter;

public class HiveMetaStoreEventHelper {
    public static final String SUCCESS_POSTFIX = "Succeed";
    public static final String FAILED_POSTFIX = "Failed";
    public static final String DB_NAME = "DBName";
    public static final String TABLE_NAME = "TableName";
    public static final String PARTITIONS = "Partitions";
    public static final String ERROR_MESSAGE = "ErrorMessage";
    public static final String PATH_REGISTRATION = "PathRegistration";
    public static final String DB_CREATION = "DBCreation";
    public static final String TABLE_CREATION = "TableCreation";
    public static final String TABLE_DROP = "TableDrop";
    public static final String TABLE_ALTER = "TableAlter";
    public static final String PARTITION_CREATION = "PartitionCreation";
    public static final String PARTITION_DROP = "PartitionDrop";
    public static final String PARTITION_ALTER = "PartitionAlter";

    protected static void submitSuccessfulPathRegistration(EventSubmitter eventSubmitter, HiveSpec spec) {
        eventSubmitter.submit("PathRegistrationSucceed", HiveMetaStoreEventHelper.getAdditionalMetadata(spec, (Optional<Exception>)Optional.absent()));
    }

    protected static void submitFailedPathRegistration(EventSubmitter eventSubmitter, HiveSpec spec, Exception error) {
        eventSubmitter.submit("PathRegistrationFailed", HiveMetaStoreEventHelper.getAdditionalMetadata(spec, (Optional<Exception>)Optional.of((Object)error)));
    }

    private static Map<String, String> getAdditionalMetadata(HiveSpec spec, Optional<Exception> error) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)DB_NAME, (Object)spec.getTable().getDbName()).put((Object)TABLE_NAME, (Object)spec.getTable().getTableName()).put((Object)"Path", (Object)spec.getPath().toString());
        if (spec.getPartition().isPresent()) {
            builder.put((Object)PARTITIONS, (Object)((HivePartition)spec.getPartition().get()).toString());
        }
        if (error.isPresent()) {
            builder.put((Object)ERROR_MESSAGE, (Object)((Exception)error.get()).getMessage());
        }
        return builder.build();
    }

    private static Map<String, String> getAdditionalMetadata(HiveTable table, Optional<HivePartition> partition, Optional<Exception> error) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)DB_NAME, (Object)table.getDbName()).put((Object)TABLE_NAME, (Object)table.getTableName());
        if (table.getLocation().isPresent()) {
            builder.put((Object)"Location", table.getLocation().get());
        }
        if (partition.isPresent()) {
            builder.put((Object)"Partition", (Object)((HivePartition)partition.get()).toString());
        }
        if (error.isPresent()) {
            builder.put((Object)ERROR_MESSAGE, (Object)((Exception)error.get()).getMessage());
        }
        return builder.build();
    }

    protected static void submitSuccessfulDBCreation(EventSubmitter eventSubmitter, String dbName) {
        eventSubmitter.submit("DBCreationSucceed", (Map)ImmutableMap.of((Object)DB_NAME, (Object)dbName));
    }

    protected static void submitFailedDBCreation(EventSubmitter eventSubmitter, String dbName, Exception error) {
        eventSubmitter.submit("DBCreationFailed", (Map)ImmutableMap.builder().put((Object)DB_NAME, (Object)dbName).put((Object)ERROR_MESSAGE, (Object)error.getMessage()).build());
    }

    protected static void submitSuccessfulTableCreation(EventSubmitter eventSubmitter, HiveTable table) {
        eventSubmitter.submit("TableCreationSucceed", HiveMetaStoreEventHelper.getAdditionalMetadata(table, (Optional<HivePartition>)Optional.absent(), (Optional<Exception>)Optional.absent()));
    }

    protected static void submitFailedTableCreation(EventSubmitter eventSubmitter, HiveTable table, Exception error) {
        eventSubmitter.submit("TableCreationFailed", HiveMetaStoreEventHelper.getAdditionalMetadata(table, (Optional<HivePartition>)Optional.absent(), (Optional<Exception>)Optional.of((Object)error)));
    }

    protected static void submitSuccessfulPartitionAdd(EventSubmitter eventSubmitter, HiveTable table, HivePartition partition) {
        eventSubmitter.submit("PartitionCreationSucceed", HiveMetaStoreEventHelper.getAdditionalMetadata(table, (Optional<HivePartition>)Optional.of((Object)partition), (Optional<Exception>)Optional.absent()));
    }

    protected static void submitFailedPartitionAdd(EventSubmitter eventSubmitter, HiveTable table, HivePartition partition, Exception error) {
        eventSubmitter.submit("PartitionCreationFailed", HiveMetaStoreEventHelper.getAdditionalMetadata(table, (Optional<HivePartition>)Optional.of((Object)partition), (Optional<Exception>)Optional.of((Object)error)));
    }

    protected static void submitSuccessfulTableDrop(EventSubmitter eventSubmitter, String dbName, String tableName, String metastoreURI) {
        eventSubmitter.submit("TableDropSucceed", (Map)ImmutableMap.builder().put((Object)DB_NAME, (Object)dbName).put((Object)TABLE_NAME, (Object)tableName).put((Object)"metastoreURI", (Object)metastoreURI).build());
    }

    protected static void submitFailedTableDrop(EventSubmitter eventSubmitter, String dbName, String tableName, Exception e) {
        eventSubmitter.submit("TableDropFailed", (Map)ImmutableMap.builder().put((Object)DB_NAME, (Object)dbName).put((Object)TABLE_NAME, (Object)tableName).put((Object)ERROR_MESSAGE, (Object)e.getMessage()).build());
    }

    protected static void submitSuccessfulPartitionDrop(EventSubmitter eventSubmitter, String dbName, String tableName, List<String> partitionValues, String metastoreURI) {
        eventSubmitter.submit("PartitionDropSucceed", (Map)ImmutableMap.builder().put((Object)DB_NAME, (Object)dbName).put((Object)TABLE_NAME, (Object)tableName).put((Object)"PartitionValues", (Object)partitionValues.toString()).put((Object)"metastoreURI", (Object)metastoreURI).build());
    }

    protected static void submitFailedPartitionDrop(EventSubmitter eventSubmitter, String dbName, String tableName, List<String> partitionValues, Exception error) {
        eventSubmitter.submit("PartitionDropFailed", (Map)ImmutableMap.builder().put((Object)DB_NAME, (Object)dbName).put((Object)TABLE_NAME, (Object)tableName).put((Object)"PartitionValues", (Object)partitionValues.toString()).put((Object)ERROR_MESSAGE, (Object)error.getMessage()).build());
    }

    protected static void submitSuccessfulTableAlter(EventSubmitter eventSubmitter, HiveTable table) {
        eventSubmitter.submit("TableAlterSucceed", HiveMetaStoreEventHelper.getAdditionalMetadata(table, (Optional<HivePartition>)Optional.absent(), (Optional<Exception>)Optional.absent()));
    }

    protected static void submitFailedTableAlter(EventSubmitter eventSubmitter, HiveTable table, Exception error) {
        eventSubmitter.submit("TableAlterFailed", HiveMetaStoreEventHelper.getAdditionalMetadata(table, (Optional<HivePartition>)Optional.absent(), (Optional<Exception>)Optional.of((Object)error)));
    }

    protected static void submitSuccessfulPartitionAlter(EventSubmitter eventSubmitter, HiveTable table, HivePartition partition) {
        eventSubmitter.submit("PartitionAlterSucceed", HiveMetaStoreEventHelper.getAdditionalMetadata(table, (Optional<HivePartition>)Optional.of((Object)partition), (Optional<Exception>)Optional.absent()));
    }

    protected static void submitFailedPartitionAlter(EventSubmitter eventSubmitter, HiveTable table, HivePartition partition, Exception error) {
        eventSubmitter.submit("PartitionAlterFailed", HiveMetaStoreEventHelper.getAdditionalMetadata(table, (Optional<HivePartition>)Optional.of((Object)partition), (Optional<Exception>)Optional.of((Object)error)));
    }
}

