/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka.workunit.packer;

import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.source.extractor.extract.AbstractSource;
import org.apache.gobblin.source.extractor.extract.kafka.workunit.packer.KafkaWorkUnitPacker;
import org.apache.gobblin.source.workunit.MultiWorkUnit;
import org.apache.gobblin.source.workunit.WorkUnit;

public class KafkaSingleLevelWorkUnitPacker
extends KafkaWorkUnitPacker {
    protected KafkaSingleLevelWorkUnitPacker(AbstractSource<?, ?> source, SourceState state) {
        super(source, state);
    }

    @Override
    public List<WorkUnit> pack(Map<String, List<WorkUnit>> workUnitsByTopic, int numContainers) {
        this.setWorkUnitEstSizes(workUnitsByTopic);
        ArrayList workUnits = Lists.newArrayList();
        for (List<WorkUnit> workUnitsForTopic : workUnitsByTopic.values()) {
            MultiWorkUnit zeroSizeWorkUnit = MultiWorkUnit.createEmpty();
            for (WorkUnit workUnit : workUnitsForTopic) {
                if (DoubleMath.fuzzyEquals((double)KafkaSingleLevelWorkUnitPacker.getWorkUnitEstSize(workUnit), (double)0.0, (double)0.01)) {
                    KafkaSingleLevelWorkUnitPacker.addWorkUnitToMultiWorkUnit(workUnit, zeroSizeWorkUnit);
                    continue;
                }
                workUnit.setWatermarkInterval(KafkaSingleLevelWorkUnitPacker.getWatermarkIntervalFromWorkUnit(workUnit));
                workUnits.add(workUnit);
            }
            if (zeroSizeWorkUnit.getWorkUnits().isEmpty()) continue;
            workUnits.add(this.squeezeMultiWorkUnit(zeroSizeWorkUnit));
        }
        return this.worstFitDecreasingBinPacking(workUnits, numContainers);
    }
}

