/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.dataset.DatasetDescriptor;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.kafka.client.GobblinKafkaConsumerClient;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.lineage.LineageInfo;
import org.apache.gobblin.source.extractor.extract.EventBasedSource;
import org.apache.gobblin.source.extractor.extract.kafka.ConfigStoreUtils;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaOffsetRetrievalFailureException;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaPartition;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaTopic;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaUtils;
import org.apache.gobblin.source.extractor.extract.kafka.MultiLongWatermark;
import org.apache.gobblin.source.extractor.extract.kafka.PreviousOffsetNotFoundException;
import org.apache.gobblin.source.extractor.extract.kafka.StartOffsetOutOfRangeException;
import org.apache.gobblin.source.extractor.extract.kafka.workunit.packer.KafkaWorkUnitPacker;
import org.apache.gobblin.source.workunit.Extract;
import org.apache.gobblin.source.workunit.MultiWorkUnit;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.DatasetFilterUtils;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.dataset.DatasetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaSource<S, D>
extends EventBasedSource<S, D> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSource.class);
    public static final String TOPIC_BLACKLIST = "topic.blacklist";
    public static final String TOPIC_WHITELIST = "topic.whitelist";
    public static final String LATEST_OFFSET = "latest";
    public static final String EARLIEST_OFFSET = "earliest";
    public static final String NEAREST_OFFSET = "nearest";
    public static final String BOOTSTRAP_WITH_OFFSET = "bootstrap.with.offset";
    public static final String DEFAULT_BOOTSTRAP_WITH_OFFSET = "latest";
    public static final String TOPICS_MOVE_TO_LATEST_OFFSET = "topics.move.to.latest.offset";
    public static final String RESET_ON_OFFSET_OUT_OF_RANGE = "reset.on.offset.out.of.range";
    public static final String DEFAULT_RESET_ON_OFFSET_OUT_OF_RANGE = "nearest";
    public static final String TOPIC_NAME = "topic.name";
    public static final String PARTITION_ID = "partition.id";
    public static final String LEADER_ID = "leader.id";
    public static final String LEADER_HOSTANDPORT = "leader.hostandport";
    public static final Extract.TableType DEFAULT_TABLE_TYPE = Extract.TableType.APPEND_ONLY;
    public static final String DEFAULT_NAMESPACE_NAME = "KAFKA";
    public static final String ALL_TOPICS = "all";
    public static final String AVG_RECORD_SIZE = "avg.record.size";
    public static final String AVG_RECORD_MILLIS = "avg.record.millis";
    public static final String PREVIOUS_LATEST_OFFSET = "previousLatestOffset";
    public static final String OFFSET_FETCH_EPOCH_TIME = "offsetFetchEpochTime";
    public static final String PREVIOUS_OFFSET_FETCH_EPOCH_TIME = "previousOffsetFetchEpochTime";
    public static final String GOBBLIN_KAFKA_CONSUMER_CLIENT_FACTORY_CLASS = "gobblin.kafka.consumerClient.class";
    public static final String GOBBLIN_KAFKA_EXTRACT_ALLOW_TABLE_TYPE_NAMESPACE_CUSTOMIZATION = "gobblin.kafka.extract.allowTableTypeAndNamspaceCustomization";
    public static final String DEFAULT_GOBBLIN_KAFKA_CONSUMER_CLIENT_FACTORY_CLASS = "org.apache.gobblin.kafka.client.Kafka08ConsumerClient$Factory";
    public static final String GOBBLIN_KAFKA_SHOULD_ENABLE_DATASET_STATESTORE = "gobblin.kafka.shouldEnableDatasetStateStore";
    public static final boolean DEFAULT_GOBBLIN_KAFKA_SHOULD_ENABLE_DATASET_STATESTORE = false;
    public static final String OFFSET_FETCH_TIMER = "offsetFetchTimer";
    private final Set<String> moveToLatestTopics = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
    private final Map<KafkaPartition, Long> previousOffsets = Maps.newConcurrentMap();
    private final Map<KafkaPartition, Long> previousExpectedHighWatermarks = Maps.newConcurrentMap();
    private final Map<KafkaPartition, Long> previousOffsetFetchEpochTimes = Maps.newConcurrentMap();
    private final Set<KafkaPartition> partitionsToBeProcessed = Sets.newConcurrentHashSet();
    private final AtomicInteger failToGetOffsetCount = new AtomicInteger(0);
    private final AtomicInteger offsetTooEarlyCount = new AtomicInteger(0);
    private final AtomicInteger offsetTooLateCount = new AtomicInteger(0);
    private final ConcurrentLinkedQueue<GobblinKafkaConsumerClient> kafkaConsumerClientPool = new ConcurrentLinkedQueue();
    private static final ThreadLocal<GobblinKafkaConsumerClient> kafkaConsumerClient = new ThreadLocal();
    private GobblinKafkaConsumerClient sharedKafkaConsumerClient = null;
    private final ClassAliasResolver<GobblinKafkaConsumerClient.GobblinKafkaConsumerClientFactory> kafkaConsumerClientResolver = new ClassAliasResolver(GobblinKafkaConsumerClient.GobblinKafkaConsumerClientFactory.class);
    private volatile boolean doneGettingAllPreviousOffsets = false;
    private Extract.TableType tableType;
    private String extractNamespace;
    private boolean isFullExtract;
    private String kafkaBrokers;
    private boolean shouldEnableDatasetStateStore;
    private AtomicBoolean isDatasetStateEnabled = new AtomicBoolean(false);
    private Set<String> topicsToProcess;
    private MetricContext metricContext;
    protected Optional<LineageInfo> lineageInfo;

    private List<String> getLimiterExtractorReportKeys() {
        ArrayList<String> keyNames = new ArrayList<String>();
        keyNames.add(TOPIC_NAME);
        keyNames.add(PARTITION_ID);
        return keyNames;
    }

    private void setLimiterReportKeyListToWorkUnits(List<WorkUnit> workUnits, List<String> keyNameList) {
        if (keyNameList.isEmpty()) {
            return;
        }
        String keyList = Joiner.on((char)',').join(keyNameList.iterator());
        for (WorkUnit workUnit : workUnits) {
            workUnit.setProp("limiter.report.key.list", (Object)keyList);
        }
    }

    public List<WorkUnit> getWorkunits(SourceState state) {
        this.metricContext = Instrumented.getMetricContext((State)state, KafkaSource.class);
        this.lineageInfo = LineageInfo.getLineageInfo((SharedResourcesBroker)state.getBroker());
        ConcurrentMap workUnits = Maps.newConcurrentMap();
        if (state.getPropAsBoolean(GOBBLIN_KAFKA_EXTRACT_ALLOW_TABLE_TYPE_NAMESPACE_CUSTOMIZATION)) {
            String tableTypeStr = state.getProp("extract.table.type", DEFAULT_TABLE_TYPE.toString());
            this.tableType = Extract.TableType.valueOf((String)tableTypeStr);
            this.extractNamespace = state.getProp("extract.namespace", DEFAULT_NAMESPACE_NAME);
        } else {
            this.tableType = DEFAULT_TABLE_TYPE;
            this.extractNamespace = DEFAULT_NAMESPACE_NAME;
        }
        this.isFullExtract = state.getPropAsBoolean("extract.is.full");
        this.kafkaBrokers = state.getProp("kafka.brokers", "");
        this.shouldEnableDatasetStateStore = state.getPropAsBoolean(GOBBLIN_KAFKA_SHOULD_ENABLE_DATASET_STATESTORE, false);
        try {
            Config config = ConfigUtils.propertiesToConfig((Properties)state.getProperties());
            GobblinKafkaConsumerClient.GobblinKafkaConsumerClientFactory kafkaConsumerClientFactory = (GobblinKafkaConsumerClient.GobblinKafkaConsumerClientFactory)this.kafkaConsumerClientResolver.resolveClass(state.getProp(GOBBLIN_KAFKA_CONSUMER_CLIENT_FACTORY_CLASS, DEFAULT_GOBBLIN_KAFKA_CONSUMER_CLIENT_FACTORY_CLASS)).newInstance();
            kafkaConsumerClient.set(kafkaConsumerClientFactory.create(config));
            List<KafkaTopic> topics = this.getFilteredTopics(state);
            this.topicsToProcess = topics.stream().map(KafkaTopic::getName).collect(Collectors.toSet());
            for (String topic : this.topicsToProcess) {
                LOG.info("Discovered topic " + topic);
            }
            Map topicSpecificStateMap = DatasetUtils.getDatasetSpecificProps((Iterable)Iterables.transform(topics, (Function)new Function<KafkaTopic, String>(){

                public String apply(KafkaTopic topic) {
                    return topic.getName();
                }
            }), (State)state);
            int numOfThreads = state.getPropAsInt("kafka.source.work.units.creation.threads", 30);
            ExecutorService threadPool = Executors.newFixedThreadPool(numOfThreads, ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)LOG)));
            if (state.getPropAsBoolean("kafka.source.shareConsumerClient", false)) {
                this.sharedKafkaConsumerClient = kafkaConsumerClient.get();
            } else {
                for (int i = 0; i < numOfThreads; ++i) {
                    this.kafkaConsumerClientPool.offer(kafkaConsumerClientFactory.create(config));
                }
            }
            Stopwatch createWorkUnitStopwatch = Stopwatch.createStarted();
            for (KafkaTopic topic : topics) {
                threadPool.submit(new WorkUnitCreator(topic, state, (Optional<State>)Optional.fromNullable(topicSpecificStateMap.get(topic.getName())), workUnits));
            }
            ExecutorsUtils.shutdownExecutorService((ExecutorService)threadPool, (Optional)Optional.of((Object)LOG), (long)1L, (TimeUnit)TimeUnit.HOURS);
            LOG.info(String.format("Created workunits for %d topics in %d seconds", workUnits.size(), createWorkUnitStopwatch.elapsed(TimeUnit.SECONDS)));
            this.createEmptyWorkUnitsForSkippedPartitions(workUnits, topicSpecificStateMap, state);
            int numOfMultiWorkunits = state.getPropAsInt("mr.job.max.mappers", 100);
            List<WorkUnit> workUnitList = KafkaWorkUnitPacker.getInstance(this, state).pack(workUnits, numOfMultiWorkunits);
            this.addTopicSpecificPropsToWorkUnits(workUnitList, topicSpecificStateMap);
            this.setLimiterReportKeyListToWorkUnits(workUnitList, this.getLimiterExtractorReportKeys());
            List<WorkUnit> list = workUnitList;
            return list;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (kafkaConsumerClient.get() != null) {
                    kafkaConsumerClient.get().close();
                }
                for (GobblinKafkaConsumerClient client : this.kafkaConsumerClientPool) {
                    client.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Exception closing kafkaConsumerClient");
            }
        }
    }

    private void addTopicSpecificPropsToWorkUnits(List<WorkUnit> workUnits, Map<String, State> topicSpecificStateMap) {
        for (WorkUnit workUnit : workUnits) {
            this.addTopicSpecificPropsToWorkUnit(workUnit, topicSpecificStateMap);
        }
    }

    private void addTopicSpecificPropsToWorkUnit(WorkUnit workUnit, Map<String, State> topicSpecificStateMap) {
        if (workUnit instanceof MultiWorkUnit) {
            for (WorkUnit wu : ((MultiWorkUnit)workUnit).getWorkUnits()) {
                this.addTopicSpecificPropsToWorkUnit(wu, topicSpecificStateMap);
            }
        } else {
            if (!workUnit.contains(TOPIC_NAME)) {
                return;
            }
            this.addDatasetUrnOptionally(workUnit);
            if (topicSpecificStateMap == null) {
                return;
            }
            if (!topicSpecificStateMap.containsKey(workUnit.getProp(TOPIC_NAME))) {
                return;
            }
            workUnit.addAll(topicSpecificStateMap.get(workUnit.getProp(TOPIC_NAME)));
        }
    }

    private void addDatasetUrnOptionally(WorkUnit workUnit) {
        if (!this.shouldEnableDatasetStateStore) {
            return;
        }
        workUnit.setProp("dataset.urn", (Object)workUnit.getProp(TOPIC_NAME));
    }

    private void createEmptyWorkUnitsForSkippedPartitions(Map<String, List<WorkUnit>> workUnits, Map<String, State> topicSpecificStateMap, SourceState state) {
        this.getAllPreviousOffsetState(state);
        for (Map.Entry<KafkaPartition, Long> entry : this.previousOffsets.entrySet()) {
            KafkaPartition partition = entry.getKey();
            if (this.partitionsToBeProcessed.contains(partition)) continue;
            String topicName = partition.getTopicName();
            if (this.isDatasetStateEnabled.get() && !this.topicsToProcess.contains(topicName)) continue;
            long previousOffset = entry.getValue();
            WorkUnit emptyWorkUnit = this.createEmptyWorkUnit(partition, previousOffset, this.previousOffsetFetchEpochTimes.get(partition), (Optional<State>)Optional.fromNullable((Object)topicSpecificStateMap.get(partition.getTopicName())));
            if (workUnits.containsKey(topicName)) {
                workUnits.get(topicName).add(emptyWorkUnit);
                continue;
            }
            workUnits.put(topicName, Lists.newArrayList((Object[])new WorkUnit[]{emptyWorkUnit}));
        }
    }

    private List<WorkUnit> getWorkUnitsForTopic(KafkaTopic topic, SourceState state, Optional<State> topicSpecificState) {
        Timer.Context context = this.metricContext.timer("isTopicQualifiedTimer").time();
        boolean topicQualified = this.isTopicQualified(topic);
        context.close();
        ArrayList workUnits = Lists.newArrayList();
        for (KafkaPartition partition : topic.getPartitions()) {
            WorkUnit workUnit = this.getWorkUnitForTopicPartition(partition, state, topicSpecificState);
            this.partitionsToBeProcessed.add(partition);
            if (workUnit == null) continue;
            if (!topicQualified) {
                KafkaSource.skipWorkUnit(workUnit);
            }
            workUnits.add(workUnit);
        }
        return workUnits;
    }

    protected boolean isTopicQualified(KafkaTopic topic) {
        return true;
    }

    private static void skipWorkUnit(WorkUnit workUnit) {
        workUnit.setProp("workunit.high.water.mark", (Object)workUnit.getLowWaterMark());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WorkUnit getWorkUnitForTopicPartition(KafkaPartition partition, SourceState state, Optional<State> topicSpecificState) {
        Offsets offsets = new Offsets();
        boolean failedToGetKafkaOffsets = false;
        try (Timer.Context context = this.metricContext.timer(OFFSET_FETCH_TIMER).time();){
            offsets.setOffsetFetchEpochTime(System.currentTimeMillis());
            offsets.setEarliestOffset(kafkaConsumerClient.get().getEarliestOffset(partition));
            offsets.setLatestOffset(kafkaConsumerClient.get().getLatestOffset(partition));
        }
        catch (KafkaOffsetRetrievalFailureException e) {
            failedToGetKafkaOffsets = true;
        }
        long previousOffset = 0L;
        long previousOffsetFetchEpochTime = 0L;
        boolean previousOffsetNotFound = false;
        try {
            previousOffset = this.getPreviousOffsetForPartition(partition, state);
            offsets.setPreviousLatestOffset(this.getPreviousExpectedHighWatermark(partition, state));
            previousOffsetFetchEpochTime = this.getPreviousOffsetFetchEpochTimeForPartition(partition, state);
            offsets.setPreviousOffsetFetchEpochTime(previousOffsetFetchEpochTime);
        }
        catch (PreviousOffsetNotFoundException e) {
            previousOffsetNotFound = true;
        }
        if (failedToGetKafkaOffsets) {
            this.failToGetOffsetCount.incrementAndGet();
            LOG.warn(String.format("Failed to retrieve earliest and/or latest offset for partition %s. This partition will be skipped.", partition));
            if (previousOffsetNotFound) {
                return null;
            }
            WorkUnit workUnit = this.createEmptyWorkUnit(partition, previousOffset, previousOffsetFetchEpochTime, topicSpecificState);
            return workUnit;
        }
        if (this.shouldMoveToLatestOffset(partition, state)) {
            offsets.startAtLatestOffset();
            return this.getWorkUnitForTopicPartition(partition, offsets, topicSpecificState);
        }
        if (previousOffsetNotFound) {
            String offsetNotFoundMsg = String.format("Previous offset for partition %s does not exist. ", partition);
            String offsetOption = state.getProp(BOOTSTRAP_WITH_OFFSET, "latest").toLowerCase();
            if (offsetOption.equals("latest")) {
                LOG.warn(offsetNotFoundMsg + "This partition will start from the latest offset: " + offsets.getLatestOffset());
                offsets.startAtLatestOffset();
                return this.getWorkUnitForTopicPartition(partition, offsets, topicSpecificState);
            }
            if (offsetOption.equals(EARLIEST_OFFSET)) {
                LOG.warn(offsetNotFoundMsg + "This partition will start from the earliest offset: " + offsets.getEarliestOffset());
                offsets.startAtEarliestOffset();
                return this.getWorkUnitForTopicPartition(partition, offsets, topicSpecificState);
            }
            LOG.warn(offsetNotFoundMsg + "This partition will be skipped.");
            return null;
        }
        try {
            offsets.startAt(previousOffset);
            return this.getWorkUnitForTopicPartition(partition, offsets, topicSpecificState);
        }
        catch (StartOffsetOutOfRangeException e) {
            if (offsets.getStartOffset() <= offsets.getLatestOffset()) {
                this.offsetTooEarlyCount.incrementAndGet();
            } else {
                this.offsetTooLateCount.incrementAndGet();
            }
            String offsetOutOfRangeMsg = String.format("Start offset for partition %s is out of range. Start offset = %d, earliest offset = %d, latest offset = %d.", partition, offsets.getStartOffset(), offsets.getEarliestOffset(), offsets.getLatestOffset());
            String offsetOption = state.getProp(RESET_ON_OFFSET_OUT_OF_RANGE, "nearest").toLowerCase();
            if (offsetOption.equals("latest") || offsetOption.equals("nearest") && offsets.getStartOffset() >= offsets.getLatestOffset()) {
                LOG.warn(offsetOutOfRangeMsg + "This partition will start from the latest offset: " + offsets.getLatestOffset());
                offsets.startAtLatestOffset();
                return this.getWorkUnitForTopicPartition(partition, offsets, topicSpecificState);
            }
            if (offsetOption.equals(EARLIEST_OFFSET) || offsetOption.equals("nearest")) {
                LOG.warn(offsetOutOfRangeMsg + "This partition will start from the earliest offset: " + offsets.getEarliestOffset());
                offsets.startAtEarliestOffset();
                return this.getWorkUnitForTopicPartition(partition, offsets, topicSpecificState);
            }
            LOG.warn(offsetOutOfRangeMsg + "This partition will be skipped.");
            return this.createEmptyWorkUnit(partition, previousOffset, previousOffsetFetchEpochTime, topicSpecificState);
        }
    }

    private long getPreviousOffsetFetchEpochTimeForPartition(KafkaPartition partition, SourceState state) throws PreviousOffsetNotFoundException {
        this.getAllPreviousOffsetState(state);
        if (this.previousOffsetFetchEpochTimes.containsKey(partition)) {
            return this.previousOffsetFetchEpochTimes.get(partition);
        }
        throw new PreviousOffsetNotFoundException(String.format("Previous offset fetch epoch time for topic %s, partition %s not found.", partition.getTopicName(), partition.getId()));
    }

    private long getPreviousOffsetForPartition(KafkaPartition partition, SourceState state) throws PreviousOffsetNotFoundException {
        this.getAllPreviousOffsetState(state);
        if (this.previousOffsets.containsKey(partition)) {
            return this.previousOffsets.get(partition);
        }
        throw new PreviousOffsetNotFoundException(String.format("Previous offset for topic %s, partition %s not found.", partition.getTopicName(), partition.getId()));
    }

    private long getPreviousExpectedHighWatermark(KafkaPartition partition, SourceState state) throws PreviousOffsetNotFoundException {
        this.getAllPreviousOffsetState(state);
        if (this.previousExpectedHighWatermarks.containsKey(partition)) {
            return this.previousExpectedHighWatermarks.get(partition);
        }
        throw new PreviousOffsetNotFoundException(String.format("Previous expected high watermark for topic %s, partition %s not found.", partition.getTopicName(), partition.getId()));
    }

    private synchronized void getAllPreviousOffsetState(SourceState state) {
        if (this.doneGettingAllPreviousOffsets) {
            return;
        }
        this.previousOffsets.clear();
        this.previousExpectedHighWatermarks.clear();
        this.previousOffsetFetchEpochTimes.clear();
        Map workUnitStatesByDatasetUrns = state.getPreviousWorkUnitStatesByDatasetUrns();
        if (!(workUnitStatesByDatasetUrns.isEmpty() || workUnitStatesByDatasetUrns.size() == 1 && ((String)workUnitStatesByDatasetUrns.keySet().iterator().next()).equals(""))) {
            this.isDatasetStateEnabled.set(true);
        }
        for (WorkUnitState workUnitState : state.getPreviousWorkUnitStates()) {
            List<KafkaPartition> partitions = KafkaUtils.getPartitions((State)workUnitState);
            MultiLongWatermark watermark = (MultiLongWatermark)workUnitState.getActualHighWatermark(MultiLongWatermark.class);
            MultiLongWatermark previousExpectedHighWatermark = (MultiLongWatermark)workUnitState.getWorkunit().getExpectedHighWatermark(MultiLongWatermark.class);
            Preconditions.checkArgument((partitions.size() == watermark.size() ? 1 : 0) != 0, (Object)String.format("Num of partitions doesn't match number of watermarks: partitions=%s, watermarks=%s", partitions, watermark));
            for (int i = 0; i < partitions.size(); ++i) {
                KafkaPartition partition = partitions.get(i);
                if (watermark.get(i) != -1L) {
                    this.previousOffsets.put(partition, watermark.get(i));
                }
                if (previousExpectedHighWatermark.get(i) != -1L) {
                    this.previousExpectedHighWatermarks.put(partition, previousExpectedHighWatermark.get(i));
                }
                this.previousOffsetFetchEpochTimes.put(partition, Long.valueOf(workUnitState.getProp(KafkaUtils.getPartitionPropName(OFFSET_FETCH_EPOCH_TIME, i), "0")));
            }
        }
        this.doneGettingAllPreviousOffsets = true;
    }

    private synchronized boolean shouldMoveToLatestOffset(KafkaPartition partition, SourceState state) {
        if (!state.contains(TOPICS_MOVE_TO_LATEST_OFFSET)) {
            return false;
        }
        if (this.moveToLatestTopics.isEmpty()) {
            this.moveToLatestTopics.addAll(Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)state.getProp(TOPICS_MOVE_TO_LATEST_OFFSET)));
        }
        return this.moveToLatestTopics.contains(partition.getTopicName()) || this.moveToLatestTopics.contains(ALL_TOPICS);
    }

    private WorkUnit createEmptyWorkUnit(KafkaPartition partition, long previousOffset, long previousFetchEpochTime, Optional<State> topicSpecificState) {
        Offsets offsets = new Offsets();
        offsets.setEarliestOffset(previousOffset);
        offsets.setLatestOffset(previousOffset);
        offsets.startAtEarliestOffset();
        offsets.setOffsetFetchEpochTime(previousFetchEpochTime);
        return this.getWorkUnitForTopicPartition(partition, offsets, topicSpecificState);
    }

    private WorkUnit getWorkUnitForTopicPartition(KafkaPartition partition, Offsets offsets, Optional<State> topicSpecificState) {
        Extract.TableType currentTableType = this.tableType;
        String currentExtractNamespace = this.extractNamespace;
        String currentExtractTableName = partition.getTopicName();
        boolean isCurrentFullExtract = this.isFullExtract;
        if (topicSpecificState.isPresent()) {
            State topicState = (State)topicSpecificState.get();
            if (topicState.contains("extract.table.type")) {
                currentTableType = Extract.TableType.valueOf((String)topicState.getProp("extract.table.type"));
            }
            currentExtractNamespace = topicState.getProp("extract.namespace", this.extractNamespace);
            currentExtractTableName = topicState.getProp("extract.table.name", partition.getTopicName());
            isCurrentFullExtract = topicState.getPropAsBoolean("extract.is.full", this.isFullExtract);
        }
        Extract extract = this.createExtract(currentTableType, currentExtractNamespace, currentExtractTableName);
        if (isCurrentFullExtract) {
            extract.setProp("extract.is.full", (Object)true);
        }
        WorkUnit workUnit = WorkUnit.create((Extract)extract);
        workUnit.setProp(TOPIC_NAME, (Object)partition.getTopicName());
        this.addDatasetUrnOptionally(workUnit);
        workUnit.setProp(PARTITION_ID, (Object)partition.getId());
        workUnit.setProp(LEADER_ID, (Object)partition.getLeader().getId());
        workUnit.setProp(LEADER_HOSTANDPORT, (Object)partition.getLeader().getHostAndPort().toString());
        workUnit.setProp("workunit.low.water.mark", (Object)offsets.getStartOffset());
        workUnit.setProp("workunit.high.water.mark", (Object)offsets.getLatestOffset());
        workUnit.setProp(PREVIOUS_OFFSET_FETCH_EPOCH_TIME, (Object)offsets.getPreviousOffsetFetchEpochTime());
        workUnit.setProp(OFFSET_FETCH_EPOCH_TIME, (Object)offsets.getOffsetFetchEpochTime());
        workUnit.setProp(PREVIOUS_LATEST_OFFSET, (Object)offsets.getPreviousLatestOffset());
        DatasetDescriptor source = new DatasetDescriptor("kafka", partition.getTopicName());
        source.addMetadata("brokers", this.kafkaBrokers);
        if (this.lineageInfo.isPresent()) {
            ((LineageInfo)this.lineageInfo.get()).setSource(source, (State)workUnit);
        }
        LOG.info(String.format("Created workunit for partition %s: lowWatermark=%d, highWatermark=%d, range=%d", partition, offsets.getStartOffset(), offsets.getLatestOffset(), offsets.getLatestOffset() - offsets.getStartOffset()));
        return workUnit;
    }

    private List<KafkaTopic> getFilteredTopics(SourceState state) {
        List blacklist = DatasetFilterUtils.getPatternList((State)state, (String)TOPIC_BLACKLIST);
        List whitelist = DatasetFilterUtils.getPatternList((State)state, (String)TOPIC_WHITELIST);
        List<KafkaTopic> topics = kafkaConsumerClient.get().getFilteredTopics(blacklist, whitelist);
        Optional<String> configStoreUri = ConfigStoreUtils.getConfigStoreUri(state.getProperties());
        if (configStoreUri.isPresent()) {
            List<KafkaTopic> topicsFromConfigStore = ConfigStoreUtils.getTopicsFromConfigStore(state.getProperties(), (String)configStoreUri.get(), kafkaConsumerClient.get());
            return topics.stream().filter(p -> topicsFromConfigStore.stream().anyMatch(q -> q.getName().equalsIgnoreCase(p.getName()))).collect(Collectors.toList());
        }
        return topics;
    }

    public void shutdown(SourceState state) {
        state.setProp("offset.too.early.count", (Object)this.offsetTooEarlyCount);
        state.setProp("offset.too.late.count", (Object)this.offsetTooLateCount);
        state.setProp("fail.to.get.offset.count", (Object)this.failToGetOffsetCount);
    }

    private class WorkUnitCreator
    implements Runnable {
        public static final String WORK_UNITS_FOR_TOPIC_TIMER = "workUnitsForTopicTimer";
        private final KafkaTopic topic;
        private final SourceState state;
        private final Optional<State> topicSpecificState;
        private final Map<String, List<WorkUnit>> allTopicWorkUnits;

        WorkUnitCreator(KafkaTopic topic, SourceState state, Optional<State> topicSpecificState, Map<String, List<WorkUnit>> workUnits) {
            this.topic = topic;
            this.state = state;
            this.topicSpecificState = topicSpecificState;
            this.allTopicWorkUnits = workUnits;
        }

        @Override
        public void run() {
            try (Timer.Context context = KafkaSource.this.metricContext.timer(WORK_UNITS_FOR_TOPIC_TIMER).time();){
                if (KafkaSource.this.sharedKafkaConsumerClient != null) {
                    WorkUnitCreator workUnitCreator = this;
                    kafkaConsumerClient.set(KafkaSource.this.sharedKafkaConsumerClient);
                } else {
                    GobblinKafkaConsumerClient client = (GobblinKafkaConsumerClient)KafkaSource.this.kafkaConsumerClientPool.poll();
                    Preconditions.checkNotNull((Object)client, (Object)"Unexpectedly ran out of preallocated consumer clients");
                    WorkUnitCreator workUnitCreator = this;
                    kafkaConsumerClient.set(client);
                }
                this.allTopicWorkUnits.put(this.topic.getName(), KafkaSource.this.getWorkUnitsForTopic(this.topic, this.state, (Optional<State>)this.topicSpecificState));
            }
            catch (Throwable t) {
                LOG.error("Caught error in creating work unit for " + this.topic.getName(), t);
                throw new RuntimeException(t);
            }
            finally {
                if (KafkaSource.this.sharedKafkaConsumerClient == null) {
                    WorkUnitCreator workUnitCreator = this;
                    KafkaSource.this.kafkaConsumerClientPool.offer(kafkaConsumerClient.get());
                    WorkUnitCreator workUnitCreator2 = this;
                    kafkaConsumerClient.remove();
                }
            }
        }
    }

    private static class Offsets {
        private long startOffset = 0L;
        private long earliestOffset = 0L;
        private long latestOffset = 0L;
        private long offsetFetchEpochTime = 0L;
        private long previousOffsetFetchEpochTime = 0L;
        private long previousLatestOffset = 0L;

        private Offsets() {
        }

        private void startAt(long offset) throws StartOffsetOutOfRangeException {
            if (offset < this.earliestOffset || offset > this.latestOffset) {
                throw new StartOffsetOutOfRangeException(String.format("start offset = %d, earliest offset = %d, latest offset = %d", offset, this.earliestOffset, this.latestOffset));
            }
            this.startOffset = offset;
        }

        private void startAtEarliestOffset() {
            this.startOffset = this.earliestOffset;
        }

        private void startAtLatestOffset() {
            this.startOffset = this.latestOffset;
        }

        public long getStartOffset() {
            return this.startOffset;
        }

        public long getEarliestOffset() {
            return this.earliestOffset;
        }

        public void setEarliestOffset(long earliestOffset) {
            this.earliestOffset = earliestOffset;
        }

        public long getLatestOffset() {
            return this.latestOffset;
        }

        public void setLatestOffset(long latestOffset) {
            this.latestOffset = latestOffset;
        }

        public long getOffsetFetchEpochTime() {
            return this.offsetFetchEpochTime;
        }

        public void setOffsetFetchEpochTime(long offsetFetchEpochTime) {
            this.offsetFetchEpochTime = offsetFetchEpochTime;
        }

        public long getPreviousOffsetFetchEpochTime() {
            return this.previousOffsetFetchEpochTime;
        }

        public void setPreviousOffsetFetchEpochTime(long previousOffsetFetchEpochTime) {
            this.previousOffsetFetchEpochTime = previousOffsetFetchEpochTime;
        }

        public long getPreviousLatestOffset() {
            return this.previousLatestOffset;
        }

        public void setPreviousLatestOffset(long previousLatestOffset) {
            this.previousLatestOffset = previousLatestOffset;
        }
    }
}

