/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.kafka;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.kafka.KafkaAvroSchemaRegistry;
import org.apache.gobblin.metrics.kafka.KafkaEventReporter;
import org.apache.gobblin.metrics.reporter.util.AvroBinarySerializer;
import org.apache.gobblin.metrics.reporter.util.AvroSerializer;
import org.apache.gobblin.metrics.reporter.util.SchemaRegistryVersionWriter;
import org.apache.gobblin.metrics.reporter.util.SchemaVersionWriter;

public class KafkaAvroEventReporter
extends KafkaEventReporter {
    protected KafkaAvroEventReporter(Builder<?> builder) throws IOException {
        super(builder);
        if (((Builder)builder).registry.isPresent()) {
            Schema schema = new Schema.Parser().parse(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("GobblinTrackingEvent.avsc"));
            this.serializer.setSchemaVersionWriter((SchemaVersionWriter)new SchemaRegistryVersionWriter((KafkaAvroSchemaRegistry)((Builder)builder).registry.get(), builder.topic, (Optional<Schema>)Optional.of((Object)schema)));
        }
    }

    @Override
    protected AvroSerializer<GobblinTrackingEvent> createSerializer(SchemaVersionWriter schemaVersionWriter) throws IOException {
        return new AvroBinarySerializer(GobblinTrackingEvent.SCHEMA$, schemaVersionWriter);
    }

    @Deprecated
    public static Builder<? extends Builder<?>> forContext(MetricContext context) {
        return new BuilderImpl(context);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends KafkaEventReporter.Builder<T> {
        private Optional<KafkaAvroSchemaRegistry> registry = Optional.absent();

        private Builder(MetricContext context) {
            super(context);
        }

        public T withSchemaRegistry(KafkaAvroSchemaRegistry registry) {
            this.registry = Optional.of((Object)registry);
            return (T)((Object)((Builder)this.self()));
        }

        @Override
        public KafkaAvroEventReporter build(String brokers, String topic) throws IOException {
            this.brokers = brokers;
            this.topic = topic;
            return new KafkaAvroEventReporter(this);
        }
    }

    public static abstract class Factory {
        public static BuilderImpl forContext(MetricContext context) {
            return new BuilderImpl(context);
        }
    }

    private static class BuilderImpl
    extends Builder<BuilderImpl> {
        private BuilderImpl(MetricContext context) {
            super(context);
        }

        protected BuilderImpl self() {
            return this;
        }
    }
}

