/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.sftp;

import com.google.common.collect.Lists;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.extractor.extract.sftp.SftpFsHelper;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelperException;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class SftpLightWeightFileSystem
extends FileSystem {
    private static final URI NAME = URI.create("sftp:///");
    private SftpFsHelper fsHelper;
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final PathFilter VALID_PATH_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            if (path == null) {
                return false;
            }
            if (StringUtils.isBlank((CharSequence)path.toString())) {
                return false;
            }
            if (path.toString().equals(".")) {
                return false;
            }
            return !path.toString().equals("..");
        }
    };

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        State state = HadoopUtils.getStateFromConf((Configuration)conf);
        this.fsHelper = new SftpFsHelper(state);
        try {
            this.fsHelper.connect();
        }
        catch (FileBasedHelperException e) {
            throw new IOException(e);
        }
    }

    public boolean delete(Path path) throws IOException {
        ChannelSftp channel = null;
        try {
            channel = this.fsHelper.getSftpChannel();
            if (this.getFileStatus(path).isDirectory()) {
                channel.rmdir(HadoopUtils.toUriPath((Path)path));
            } else {
                channel.rm(HadoopUtils.toUriPath((Path)path));
            }
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        finally {
            SftpLightWeightFileSystem.safeDisconnect((Channel)channel);
        }
        return true;
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        return this.delete(path);
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        FileStatus fileStatus;
        ChannelSftp channelSftp = null;
        ChannelExec channelExec1 = null;
        ChannelExec channelExec2 = null;
        try {
            FileStatus fs;
            channelSftp = this.fsHelper.getSftpChannel();
            SftpATTRS sftpAttrs = channelSftp.stat(HadoopUtils.toUriPath((Path)path));
            FsPermission permission = new FsPermission((short)sftpAttrs.getPermissions());
            channelExec1 = this.fsHelper.getExecChannel("id " + sftpAttrs.getUId());
            String userName = IOUtils.toString((InputStream)channelExec1.getInputStream());
            channelExec2 = this.fsHelper.getExecChannel("id " + sftpAttrs.getGId());
            String groupName = IOUtils.toString((InputStream)channelExec2.getInputStream());
            fileStatus = fs = new FileStatus(sftpAttrs.getSize(), sftpAttrs.isDir(), 1, 0L, (long)sftpAttrs.getMTime(), (long)sftpAttrs.getATime(), permission, StringUtils.trimToEmpty((String)userName), StringUtils.trimToEmpty((String)groupName), path);
        }
        catch (SftpException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                SftpLightWeightFileSystem.safeDisconnect((Channel)channelSftp);
                SftpLightWeightFileSystem.safeDisconnect(channelExec1);
                SftpLightWeightFileSystem.safeDisconnect(channelExec2);
                throw throwable;
            }
        }
        SftpLightWeightFileSystem.safeDisconnect((Channel)channelSftp);
        SftpLightWeightFileSystem.safeDisconnect((Channel)channelExec1);
        SftpLightWeightFileSystem.safeDisconnect((Channel)channelExec2);
        return fileStatus;
    }

    public URI getUri() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getWorkingDirectory() {
        ChannelSftp channelSftp = null;
        try {
            Path workingDir;
            channelSftp = this.fsHelper.getSftpChannel();
            Path path = workingDir = new Path(channelSftp.pwd());
            return path;
        }
        catch (SftpException e) {
            Path path = null;
            return path;
        }
        finally {
            SftpLightWeightFileSystem.safeDisconnect((Channel)channelSftp);
        }
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        try {
            List<String> fileNames = this.fsHelper.ls(HadoopUtils.toUriPath((Path)path));
            ArrayList status = Lists.newArrayListWithCapacity((int)fileNames.size());
            for (String name : fileNames) {
                Path filePath = new Path(name);
                if (!VALID_PATH_FILTER.accept(filePath)) continue;
                status.add(this.getFileStatus(new Path(path, filePath)));
            }
            return status.toArray(new FileStatus[status.size()]);
        }
        catch (FileBasedHelperException e) {
            throw new IOException(e);
        }
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        ChannelSftp channel = null;
        try {
            channel = this.fsHelper.getSftpChannel();
            channel.mkdir(HadoopUtils.toUriPath((Path)path));
            channel.chmod((int)permission.toShort(), HadoopUtils.toUriPath((Path)path));
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        finally {
            SftpLightWeightFileSystem.safeDisconnect((Channel)channel);
        }
        return true;
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        SftpFsHelper.SftpGetMonitor monitor = new SftpFsHelper.SftpGetMonitor();
        try {
            ChannelSftp channelSftp = this.fsHelper.getSftpChannel();
            InputStream is = channelSftp.get(HadoopUtils.toUriPath((Path)path), (SftpProgressMonitor)monitor);
            return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new SftpFsHelper.SftpFsFileInputStream(is, (Channel)channelSftp), bufferSize));
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
    }

    public FSDataInputStream open(Path path) throws IOException {
        return this.open(path, 32768);
    }

    public boolean rename(Path oldPath, Path newPath) throws IOException {
        ChannelSftp channelSftp = null;
        try {
            channelSftp = this.fsHelper.getSftpChannel();
            channelSftp.rename(HadoopUtils.toUriPath((Path)oldPath), HadoopUtils.toUriPath((Path)newPath));
        }
        catch (SftpException e) {
            throw new IOException(e);
        }
        finally {
            SftpLightWeightFileSystem.safeDisconnect((Channel)channelSftp);
        }
        return true;
    }

    public void setWorkingDirectory(Path path) {
        ChannelSftp channelSftp = null;
        try {
            channelSftp = this.fsHelper.getSftpChannel();
            channelSftp.lcd(HadoopUtils.toUriPath((Path)path));
        }
        catch (SftpException e) {
            throw new RuntimeException("Failed to set working directory", e);
        }
        finally {
            SftpLightWeightFileSystem.safeDisconnect((Channel)channelSftp);
        }
    }

    public void close() {
        this.fsHelper.close();
    }

    public FSDataOutputStream append(Path arg0, int arg1, Progressable arg2) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public FSDataOutputStream create(Path arg0, FsPermission arg1, boolean arg2, int arg3, short arg4, long arg5, Progressable arg6) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static void safeDisconnect(Channel channel) {
        if (channel != null) {
            channel.disconnect();
        }
    }
}

