/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google.webmaster;

import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.services.webmasters.model.ApiDataRow;
import com.google.api.services.webmasters.model.ApiDimensionFilter;
import com.google.api.services.webmasters.model.SearchAnalyticsQueryResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterFilter;
import org.apache.gobblin.ingestion.google.webmaster.ProducerJob;

public abstract class GoogleWebmasterDataFetcher {
    public abstract String getSiteProperty();

    public abstract List<String[]> performSearchAnalyticsQuery(String var1, String var2, int var3, List<GoogleWebmasterFilter.Dimension> var4, List<Metric> var5, Collection<ApiDimensionFilter> var6) throws IOException;

    public abstract void performSearchAnalyticsQueryInBatch(List<ProducerJob> var1, List<ArrayList<ApiDimensionFilter>> var2, List<JsonBatchCallback<SearchAnalyticsQueryResponse>> var3, List<GoogleWebmasterFilter.Dimension> var4, int var5) throws IOException;

    public abstract Collection<ProducerJob> getAllPages(String var1, String var2, String var3, int var4) throws IOException;

    public static List<String[]> convertResponse(List<Metric> requestedMetrics, SearchAnalyticsQueryResponse response) {
        List rows = response.getRows();
        if (rows == null || rows.isEmpty()) {
            return new ArrayList<String[]>();
        }
        int arraySize = ((ApiDataRow)rows.get(0)).getKeys().size() + requestedMetrics.size();
        ArrayList<String[]> ret = new ArrayList<String[]>(rows.size());
        for (ApiDataRow row : rows) {
            int i;
            List keys = row.getKeys();
            String[] data = new String[arraySize];
            for (i = 0; i < keys.size(); ++i) {
                data[i] = (String)keys.get(i);
            }
            for (Metric requestedMetric : requestedMetrics) {
                if (requestedMetric == Metric.CLICKS) {
                    data[i] = row.getClicks().toString();
                } else if (requestedMetric == Metric.IMPRESSIONS) {
                    data[i] = row.getImpressions().toString();
                } else if (requestedMetric == Metric.CTR) {
                    data[i] = String.format("%.5f", row.getCtr());
                } else if (requestedMetric == Metric.POSITION) {
                    data[i] = String.format("%.2f", row.getPosition());
                } else {
                    throw new RuntimeException("Unknown Google Webmaster Metric Type");
                }
                ++i;
            }
            ret.add(data);
        }
        return ret;
    }

    static enum Metric {
        CLICKS,
        IMPRESSIONS,
        CTR,
        POSITION;

    }
}

